%def_disable    check

Name: python3-module-sqlalchemy
Version: 2.0.37
Release: alt0.1

Summary: Python SQL toolkit and Object Relational Mapper
License: MIT
Group: Development/Python
Url: http://www.sqlalchemy.org/
BuildArch: noarch

Source: SQLAlchemy-%version.tar

Provides: python3-module-SQLAlchemy = %EVR
Obsoletes: python3-module-SQLAlchemy

%py3_provides SQLAlchemy

BuildRequires: rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
%if_enabled check
BuildRequires: python3(cython)
BuildRequires: python3(pytest)
BuildRequires: python3(typing_extensions)
BuildRequires: python3(greenlet)
BuildRequires: python3(xdist)
%endif

# Make sure that at least the Python built-in sqlite driver
# is present (and can be used by SQLAlchemy--among other things--
# in various tests, like in the tests for sphinx).
Requires: python3-modules-sqlite3

%description
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

%if_enabled check
%package tests
Summary: Tests for SQLAlchemy (Python 3)
Group: Development/Python3
Requires: %name = %EVR

%description tests
SQLAlchemy is the Python SQL toolkit and Object Relational Mapper that gives
application developers the full power and flexibility of SQL.

It provides a full suite of well known enterprise-level persistence patterns,
designed for efficient and high-performing database access, adapted into a
simple and Pythonic domain language.

This package contains tests for SQLAlchemy.
%endif

%prep
%setup -n SQLAlchemy-%version

%build
%pyproject_build

%install
%pyproject_install

%add_python3_req_skip sqlalchemy.testing
%add_python3_req_skip sqlalchemy.testing.provision

%check
%pyproject_run_pytest -m "not memory_intensive and not mypy" test

%files
%python3_sitelibdir_noarch/*
%if_enabled check
%exclude %python3_sitelibdir/*/testing
%endif

%if_enabled check
%files tests
%python3_sitelibdir/*/testing
%endif

%changelog
