%define oname sqlalchemy_mptt
%def_without pickles
%def_without docs
%def_without check

Name: python3-module-%oname
Version: 0.2.5
Release: alt3

Summary: SQLAlchemy MPTT mixins (Nested Sets)
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/sqlalchemy_mptt/
BuildArch: noarch

# https://github.com/ITCase/sqlalchemy_mptt.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro
%if_with docs
BuildRequires: python3-module-sphinx
%endif

# generated by 'epm restore --dry-run' from python3-module-sqlalchemy_mptt/requirements.txt
%py3_use SQLAlchemy >= 1.0.0

%if_with check
# generated by 'epm restore --dry-run' from python3-module-sqlalchemy_mptt/requirements-test.txt
%py3_buildrequires nose
%py3_buildrequires flake8
%py3_buildrequires coverage
BuildRequires: pytest3
%endif

%py3_provides %oname
%py3_requires sqlite3


%description
Library for implementing Modified Preorder Tree Traversal with your
SQLAlchemy Models and working with trees of Model instances, like
django-mptt.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
Library for implementing Modified Preorder Tree Traversal with your
SQLAlchemy Models and working with trees of Model instances, like
django-mptt.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Library for implementing Modified Preorder Tree Traversal with your
SQLAlchemy Models and working with trees of Model instances, like
django-mptt.

This package contains documentation for %oname.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' docs/Makefile

sed -i 's|#!.*/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
export LC_ALL=en_US.UTF-8
%python3_build_debug

%install
export LC_ALL=en_US.UTF-8
%python3_install

%if_with docs
%make -C docs html
%endif
%if_with pickles
%make -C docs pickle
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
pytest3

%files
%doc *.txt *.rst
%python3_sitelibdir/*
%if_with pickles
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle
%endif

%if_with docs
%files docs
%doc docs/_build/html/*
%endif


%changelog
