%define oname stestr

%def_with check
%def_with docs

Name: python3-module-%oname
Version: 4.1.0
Release: alt3

Summary: stestr is parallel Python test runner

Group: Development/Python3
License: Apache-2.0
URL: https://pypi.org/project/stestr
VCS: https://github.com/mtreinish/stestr

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-cliff
BuildRequires: python3-module-testtools
BuildRequires: python3-module-subunit
BuildRequires: python3-module-voluptuous
%endif

%if_with check
BuildRequires: python3-module-ddt
BuildRequires: python3-module-yaml
BuildRequires: python3-module-tomlkit
BuildRequires: python3-module-iso8601
BuildRequires: python3-module-extras
%endif

%description
stestr is parallel Python test runner designed to execute unittest test suites
using multiple processes to split up execution of a test suite.
It also will store a history of all test runs to help in debugging failures
and optimizing the scheduler to improve speed. To accomplish this goal
it uses the subunit protocol to facilitate streaming and storing results
from multiple workers.

stestr originally started as a fork of the testrepository project.
But, instead of being an interface for any test runner that used subunit,
like testrepository, stestr concentrated on being a dedicated test runner
for python projects.
While stestr was originally forked from testrepository it is not
backwards compatible with testrepository.
At a high level the basic concepts of operation are shared between the two
projects but the actual usage is not exactly the same.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%package doc
Summary: Documentation for stestr
Group: Development/Documentation

%description doc
Documentation for stestr.

%prep
%setup

# Remove bundled egg-info
rm -rf %oname.egg-info

%build
export PBR_VERSION=%version
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%check
# synced to .github/workflows/main.yml and tox.ini
%pyproject_run -- stestr run

%files
%doc LICENSE *.rst
%_bindir/%oname
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%exclude %python3_sitelibdir/*/tests

%files tests
%python3_sitelibdir/*/tests

%files doc
%doc LICENSE html

%changelog
