%define oname swiftclient
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 4.4.0
Release: alt1

Summary: OpenStack Object Storage API Client Library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/python-swiftclient

Source: %oname-%version.tar
Source1: %oname.watch

Patch: swiftclient-fix-call-assertion.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr
BuildRequires: python3-module-requests >= 2.4.0

%if_with check
BuildRequires: python3-module-keystoneclient >= 0.7.0
BuildRequires: python3-module-keystoneauth1 >= 3.4.0
BuildRequires: python3-module-mock >= 1.2.0
BuildRequires: python3-module-hacking >= 3.2.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-openstacksdk >= 0.11.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
%endif

%description
There's a Python API (the swiftclient module), and a command-line script (swift).

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

%patch -p1

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/python-%oname.1 %buildroot%_man1dir/%oname.1
%endif

# install bash completion
install -pDm 644 tools/swift.bash_completion \
  %buildroot%_sysconfdir/bash_completion.d/swift.bash_completion

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/swift
%python3_sitelibdir/%oname
%python3_sitelibdir/python_swiftclient-%version.dist-info
%dir %_sysconfdir/bash_completion.d
%_sysconfdir/bash_completion.d/swift.bash_completion

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%_man1dir/swift.1.xz
%endif

%changelog
