%define _unpackaged_files_terminate_build 1

%define oname traitlets

%def_with check

Name: python3-module-%oname
Version: 5.14.3
Release: alt1

Summary: Traitlets Python config system

License: BSD-3-Clause
Group: Development/Python3
BuildArch: noarch
Url: https://pypi.python.org/pypi/traitlets

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(hatchling)

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(argcomplete)
BuildRequires: python3(pytest-mock)
%endif

%py3_provides %oname

%description
A configuration system for Python applications.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
A configuration system for Python applications.

This package contains tests for %oname.

%prep
%setup
sed -i 's/"--color=yes",//' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v --ignore tests/test_typing.py

%files
%doc README.*
%python3_sitelibdir/traitlets/
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/*/tests

%changelog
