%define modname twitter

Name: python3-module-%modname
Version: 3.5
Release: alt2

Summary: Python Interface for Twitter API
License: Apache-2.0
Group: Development/Python3
Url: https://github.com/bear/python-twitter
BuildArch: noarch

Source: twitter-%version.tar
Patch0: fix-build-for-python3.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme

%py3_requires rfc822py3 requests requests_oauthlib
%add_python3_req_skip rfc822
%py3_provides %modname


%description
This library provides a pure python interface for the Twitter API.

%prep
%setup -n twitter-%version
%patch0 -p1
# commited in f4d9161adb44b1fab7a6d88de00b4ddcf196fd55
sed -i '/pytest-runner/d' setup.py

sed -i 's|#!/usr/bin/env python.*|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build

export PYTHONPATH=%buildroot%python3_sitelibdir
sphinx-build-3 doc/ _build/ doc/*.rst
mkdir man
cp -fR doc/_build/html/* man/

%install
%python3_install

%files
%doc AUTHORS.* CHANGES COPYING LICENSE README.*
%doc examples/ man/
%python3_sitelibdir/*


%changelog
