%define _unpackaged_files_terminate_build 1
%define optflags_lto %nil
%define pypi_name uv
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 0.5.27
Release: alt1
Summary: An extremely fast Python package installer and resolver
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/uv
Vcs: https://github.com/astral-sh/uv
Source: %name-%version.tar
Source1: vendor_rust.tar
Source2: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
Requires: %pypi_name
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: /usr/bin/cmake
BuildRequires: libssl-devel
%if_with check
%pyproject_builddeps_metadata
%endif

%description
An extremely fast Python package installer and resolver, written in Rust.
Designed as a drop-in replacement for common pip and pip-tools workflows.

%package -n %pypi_name
Summary: %summary
Group: Development/Python3
# uv executable was shipped in python package
Conflicts: python3-module-%pypi_name <= 0.5.26-alt1

%description -n %pypi_name
%summary.

%prep
%setup -a1
%autopatch -p1
cat < vendor_cargoconf.toml >> .cargo/config.toml
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
export CARGO_TERM_VERBOSE=true
%ifarch %ix86
# fails with upstream's lto=fat
export CARGO_PROFILE_RELEASE_LTO=thin
%endif
%pyproject_build

%install
%pyproject_install

%check
# smoke test
%pyproject_run -- uv --help

%files
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%files -n %pypi_name
%doc README.*
%_bindir/uv
%_bindir/uvx

%changelog
