%define _unpackaged_files_terminate_build 1
%define pypi_name wcwidth
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 0.2.13
Release: alt1
Summary: Measures number of Terminal column cells of wide-character codes
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/wcwidth/
Vcs: https://github.com/jquast/wcwidth
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter docformatter restructuredtext-lint
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
This API is mainly for Terminal Emulator implementors - any python
program that attempts to determine the printable width of a string on a
Terminal. It is implemented in python (no C library calls) and has no
3rd-party dependencies.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements-tests39.in
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
# get rid of tox.ini as pytest's config:
# [pytest] section and its cov cli options
rm tox.ini
%pyproject_run_pytest -ra tests

%files
%doc README.rst
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
