%define oname zope.dottedname

%def_with check

Name: python3-module-%oname
Version: 6.0
Release: alt2.1

Summary: Resolver for Python dotted names
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.dottedname
Vcs: https://github.com/zopefoundation/zope.dottedname

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-sphinx
%endif

%py3_requires zope

%description
Resolve strings containing dotted names into the appropriate python object.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.testing

%description tests
Resolve strings containing dotted names into the appropriate python object.

This package contains tests for %oname.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt *.rst
%python3_sitelibdir/zope/dottedname
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests.*
%exclude %python3_sitelibdir/*/*/example.*

%files tests
%python3_sitelibdir/*/*/tests.*
%python3_sitelibdir/*/*/example.*


%changelog
