%define pypi_name zope.errorview

# Depends on zope.browserpage which has been deleted from repo
%def_without check

Name: python3-module-%pypi_name
Version: 2.0
Release: alt1.1

Summary: Basic HTTP and Browser exception views
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/zope.errorview
Vcs: https://github.com/zopefoundation/zope.errorview

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-zope.component
BuildRequires: python3-module-zope.component-tests
BuildRequires: python3-module-zope.i18n
BuildRequires: python3-module-zope.publisher
BuildRequires: python3-module-zope.authentication
BuildRequires: python3-module-zope.browser
%endif

%description
Provides basic HTTP and Browser views for common exceptions.

%package tests
Summary: Tests for zope.errorview
Group: Development/Python3
Requires: %name = %EVR
%py3_requires zope.testing

%description tests
Provides basic HTTP and Browser views for common exceptions.

This package contains tests for zope.errorview.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.rst
%python3_sitelibdir/zope/errorview
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests

%files tests
%python3_sitelibdir/*/*/tests


%changelog
