%define oname zope.tal

%def_with check

Name: python3-module-%oname
Version: 5.1
Release: alt1.1

Summary: Zope3 Template Attribute Languate
License: ZPL-2.1
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.tal/
VCS: https://github.com/zopefoundation/zope.tal.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-zope.i18nmessageid
BuildRequires: python3-module-zope.interface
BuildRequires: python3-module-zope.testrunner
%endif

%add_python3_req_skip cStringIO

%description
The Zope3 Template Attribute Languate (TAL) specifies the custom
namespace and attributes which are used by the Zope Page Templates
renderer to inject dynamic markup into a page. It also includes the
Macro Expansion for TAL (METAL) macro language used in page assembly.

The dynamic values themselves are specified using a companion language,
TALES (see the 'zope.tales' package for more).

%package tests
Summary: Tests for Zope 3 Template Attribute Languate (TAL)
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-module-zope.testing

%description tests
The Zope3 Template Attribute Languate (TAL) specifies the custom
namespace and attributes which are used by the Zope Page Templates
renderer to inject dynamic markup into a page. It also includes the
Macro Expansion for TAL (METAL) macro language used in page assembly.

The dynamic values themselves are specified using a companion language,
TALES (see the 'zope.tales' package for more).

This package contains tests for Zope3 Template Attribute Languate.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%if "%_lib" == "lib64"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
	%buildroot%python3_sitelibdir/
%endif

%check
rm -rf src/zope/tal/tests/test_files.py
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc README.*
%python3_sitelibdir/zope/tal
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/*.pth
%exclude %python3_sitelibdir/*/*/tests
%exclude %python3_sitelibdir/*/*/runtest.*
%exclude %python3_sitelibdir/*/*/*/runtest.*

%files tests
%python3_sitelibdir/*/*/tests
%python3_sitelibdir/*/*/runtest.*
%python3_sitelibdir/*/*/*/runtest.*


%changelog
