%define _unpackaged_files_terminate_build 1
%define pypi_name zope.testbrowser

%def_with check

Name: python3-module-%pypi_name
Version: 7.0.1
Release: alt1.1

Summary: Programmable browser for functional black-box tests
License: ZPL-2.1
Group: Development/Python3
Url: http://pypi.python.org/pypi/zope.testbrowser/
VCS: https://github.com/zopefoundation/zope.testbrowser.git
Source: %name-%version.tar
Patch0: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# dependencies
BuildRequires: python3(zope.interface)
BuildRequires: python3(zope.schema)
BuildRequires: python3(zope.cachedescriptors)
BuildRequires: python3(pytz)
BuildRequires: python3(webtest)
BuildRequires: python3(bs4)
BuildRequires: python3(soupsieve)
BuildRequires: python3(wsgiproxy)
BuildRequires: python3(six)

# tests
BuildRequires: python3(zope.testing)
BuildRequires: python3(mock)
BuildRequires: python3(zope.testrunner)
%endif

%description
zope.testbrowser provides an easy-to-use programmable web browser with
special focus on testing. It is used in Zope, but it's not Zope specific
at all. For instance, it can be used to test or otherwise interact with
any web site.

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir_noarch" != "%python3_sitelibdir"
install -d %buildroot%python3_sitelibdir
mv %buildroot%python3_sitelibdir_noarch/* \
    %buildroot%python3_sitelibdir/
%endif

# don't ship tests
rm -r %buildroot%python3_sitelibdir/zope/testbrowser/tests/

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc CHANGES.rst README.rst
%python3_sitelibdir/zope/testbrowser/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*.pth

%changelog
