# ======================================================
# Conditionals and other variables controlling the build
# ======================================================

# This knob is added ONLY for maintainer's convenience. Should be ALWAYS on
# in release version
%def_with check

%define _unpackaged_files_terminate_build 1

%define gdb_auto_load %_datadir/gdb/auto-load%_libdir/
# Below the same shorthands as in Redhat's spec are definied,
# but mostly through ALT Sisyphus rpm-build-python3's macros
# (to make the picture more clear and less error-prone).

%global submajor 13
%global pybasever 3.%submajor
# pybasever without the dot:
%global pyshortver 3%submajor

# Controls if this version of python3 is standalone
# Grenka, unset this macro (remove the line bellow) if you build the main one python3
%define _python3_standalone .%submajor


%global pyabi %nil

%global pynameabi python%pybasever%pyabi

# Here, we re-use the machinery of rpm-build-python3 definitions
# to generate the paths etc. in the way they are usually determined
# for the build system. (The input to this machinery is:
# %%__python3_version and %%__python3_abiflags;

%global __python3_version %pybasever
# the above also affects %%_python3_abi_version the way we need indeed.
%global __python3_abiflags %pyabi
# the above also affects %%_python3_abiflags

# they normally refer to Python3 installed in the build system,
# but we are building a new one, and not going to use the old one).

%global pylibdir %__python3_libdir
%global dynload_dir %__python3_dynlibdir
%global include_dir %__python3_includedir
%global tool_dir %_datadir/python%pybasever/Tools
%global pylibdir_noarch %__python3_libdir_noarch

%global pyarch %{expand:%(echo %{_arch}-linux-gnu | \
sed -E -e 's/^i586-linux-gnu$/i386-linux-gnu/' | \
sed -E -e 's/^armh-linux-gnu$/arm-linux-gnueabihf/' | \
sed -E -e 's/^mips64(el)?-linux-gnu$/mips64\\1-linux-gnuabi64/' | \
sed -E -e 's/^ppc(64)?(le)?-linux-gnu$/powerpc\\1\\2-linux-gnu/' | \
sed -E -e 's/^e2k[^-]{,3}-linux-gnu$/e2k-linux-gnu/')}

# All bytecode files are now in a __pycache__ subdirectory, with a name
# reflecting the version of the bytecode (to permit sharing of python libraries
# between different runtimes)
# See http://www.python.org/dev/peps/pep-3147/
# For example,
#   foo/bar.py
# now has bytecode at:
#   foo/__pycache__/bar.cpython-35.pyc
#   foo/__pycache__/bar.cpython-35.pyo
%global bytecode_suffixes .cpython-%{pyshortver}*.py?

# Python's configure script defines SOVERSION, and this is used in the Makefile
# to determine INSTSONAME, the name of the libpython DSO:
#   LDLIBRARY='libpython$(VERSION).so'
#   INSTSONAME="$LDLIBRARY".$SOVERSION
# We mirror this here in order to make it easier to add the -gdb.py hooks.
# (if these get out of sync, the payload of the libs subpackage will fail
# and halt the build)
%global py_SOVERSION 1.0

# some arches don't have valgrind so we need to disable its support on them
%ifarch %valgrind_arches
%def_with valgrind
%else
%def_without valgrind
%endif

%global _optlevel 3
# details at https://www.altlinux.org/LTO
%global optflags_lto %optflags_lto -ffat-lto-objects

%def_with gdbm
%def_with bluez
%def_with x11

%if_with x11
%def_with tk
%def_with gl
%else
%def_without tk
%def_without gl
%endif

%def_with desktop_file
%def_with docs

Name: python3%{?_python3_standalone}
Version: %{pybasever}.9
Release: alt2.p11.1

Summary: Version 3 of the Python programming language aka Python 3000

License: Python
Group: Development/Python3
Url: http://www.python.org/

# New common location for site-packages is supported since 0.1.9.
# %%python3_ABI_dep is defined since 0.1.9.1.
# The path macros brought in sync in 0.1.9.2.
BuildRequires(pre): rpm-build-python3 >= 0.1.29
# for %%valgrind_arches macro
BuildRequires(pre): rpm-macros-valgrind
BuildPreReq: liblzma-devel
# For Bluetooth support
# see https://bugzilla.redhat.com/show_bug.cgi?id=879720
BuildRequires: bzip2-devel db4-devel libexpat-devel gcc-c++ libgmp-devel
BuildRequires: libffi-devel libncursesw-devel mpdecimal-devel libb2-devel
BuildRequires: libssl-devel libreadline-devel libsqlite3-devel
BuildRequires: autoconf-archive
BuildRequires: zlib-devel libuuid-devel libnsl2-devel
%{?_with_bluez:BuildPreReq: libbluez-devel}
%{?_with_x11:BuildRequires: libX11-devel}
%{?_with_tk:BuildRequires: tcl-devel tk-devel}
%{?_with_gl:BuildRequires: libGL-devel}
%{?_with_gdbm:BuildRequires: gdbm-devel}
%{?_with_valgrind:BuildRequires: valgrind-devel}
%{?_with_desktop_file:BuildRequires: desktop-file-utils}
%{?!_without_check:%{?!_disable_check:BuildRequires: /dev/pts /proc}}
%{?_with_docs:BuildRequires: python3-module-sphinx python3-module-python-docs-theme}

# Fix find-requires
%global __python3 %buildroot%_bindir/python%pybasever
%add_python3_path %pylibdir
#Do not recompile .py files with old python3
%add_python3_compile_exclude %pylibdir
%filter_from_requires /gdb/d
Obsoletes: %name-module-gdb_libpython
Provides: %name-module-gdb_libpython

Source: python3-%version.tar

# Desktop menu entry for idle3
Source10: idle3.desktop

#RH Patches

#ALT Linux patches

# RLIMIT 1000000 unavailable in hasher
Patch1003: python-3.8.0-skip-test_setrusage_refcount-alt.patch

# Disable "-i386-linux-gnu"-like suffixes for lib-dynload/*.so modules.
# Disables test for those suffixes.
Patch1004: python-3.13.0-alt-disable-build-PLATFORM_TRIPLET.patch

# Use a common /usr/lib/python3/site-packages (without the minor version)
Patch1005: python3-site-packages.patch
# %%python3_sitelibdir{,_noarch} from rpm-build-python3 >= 0.1.9
# are consistent with this.
# (TODO: Perhaps, we should consider substituting the value of the macros into the patch,
# so that we have a single point of control and a guarantee of consistency.)

# With python-3.6 and later it's either needed to enable some crypto ciphers needed for SSLv2 when this socket type requested
# or SSLv2 has to be removed completely, because it wouldn't work without this change anyway.
Patch1007: python3-sslv2-compat.patch

# 'Trust mode': optional modules loading paths restriction
Patch1011: python3-ignore-env-trust-security.patch

# Sphinx required version
Patch1012: python3_sphinx_version.patch

# ======================================================
# Additional metadata, and subpackages
# ======================================================

# Like in Fedora:
Provides: python(abi) = %pybasever

# ALT's special name (looking like: python3.3-ABI(64bit)):
#
# (BTW, %%ABI_suffix is computed in a new-arch-ABI-proof way:
# if a new weird arch-ABI arises, at least, we'll have
# a weird suffix here, not coinciding with another existing one.)
Provides: %python3_ABI_dep

Requires: %name-base = %EVR

%if 0%{?!_python3_standalone:1}
%global __find_obsoletes \
  case "$RPM_SUBPACKAGE_NAME" in \
      python3|python3-*|libpython3|libpython3-debuginfo) \
         echo "${RPM_SUBPACKAGE_NAME/python3/python3%submajor}" \
	;; \
      *) echo >&2 'Unexpected subpkg!' \
	 exit 1 \
	;; \
  esac \
  %{?__find_obsoletes} \
  %{?!__find_obsoletes: cat >/dev/null} # avoid broken pipe: consume the file list
%endif

%description
Python 3 is a new version of the language that is incompatible with the 2.x
line of releases. The language is mostly the same, but many details, especially
how built-in objects like dictionaries and strings work, have changed
considerably, and a lot of deprecated features have finally been removed.

%package base
Summary: Python 3 runtime libraries
Group: Development/Python3
Provides: %name-libs = %EVR
Obsoletes: %name-libs < %EVR
%py3_provides builtins
# Prepare for the future default method (to test the result earlier):
%python3_req_hier
# It's an OS-independent alias (which other modules might want to import)
# leading to an OS-specific path module.
%py3_provides os.path
%py3_provides typing.io

%py3_provides _frozen_importlib
%py3_provides _frozen_importlib_external

# Since 3.13.1 it's provided through collections/__init__.py
# See cpython commit v3.13.1~236 (d46d291bd390027811937bbf5af2e2600b8398a9).
%py3_provides collections.abc

%filter_from_requires /^%name[[:space:]]/d
%filter_from_requires /^\/usr\/bin\/%name/d

# The package that may have provided the common
# /usr/lib{,64}/python3/site-packages
# before we patched python3 itself for supporting this path.
%define python3_sitebasename %(basename %(dirname %python3_sitelibdir))
Obsoletes: %python3_sitebasename-site-packages

# Make sure that a matching rpm-build-python3 is installed if installed.
# (After 3.6.8-alt1, the actual Requires is present only in the dev subpkg.)
Conflicts: rpm-build-python3 < 0.1.9

%description base
This package contains files used to embed Python 3 into applications.

%package dev
Summary: Libraries and header files needed for Python 3 development
Group: Development/Python3
Requires: %name = %EVR
Requires: lib%name = %EVR
Conflicts: %name < %EVR
Provides: lib%name-devel = %EVR

# ALT Sisyphus RPM Macros Packaging Policy
# makes sure that the RPM support for building
# the language-specific modules comes together with
# the compiler/-devel pkgs:
%{?!_python3_standalone:Requires: rpm-build-python3}

Provides: python3%{?_python3_standalone:-standalone}-devel = %pybasever
%if 0%{?_python3_standalone:1}
Conflicts: python3-devel
Conflicts: python3-standalone-devel <= %pybasever
%endif

%description dev
This package contains libraries and header files used to build applications
with and native libraries for Python 3

%package -n libpython3%{?_python3_standalone}
Summary: Python3 shared library
Group: Development/Python3
Requires: %name-base = %EVR

%description -n libpython3%{?_python3_standalone}
This package contains Python3 shared library

%package tools
Summary: A collection of tools included with Python 3
Group: Development/Python3
Requires: %name = %EVR
Requires: %name-modules-tkinter = %EVR
Requires: %name-modules-curses = %EVR

%add_python3_self_prov_path %buildroot%tool_dir/clinic/libclinic

%description tools
This package contains several tools included with Python 3

%package modules-tkinter
Summary: A GUI toolkit for Python 3
Group: Development/Python3
Provides: %name-modules-idlelib = %EVR
Obsoletes: %name-modules-idlelib < 3.3.1-alt4
Requires: tk tcl-tix

%description modules-tkinter
The Tkinter (Tk interface) program is an graphical user interface for
the Python scripting language.

%package modules-sqlite3
Summary: DB-API 2.0 interface for SQLite databases
Group: Development/Python3

%description modules-sqlite3
SQLite is a C library that provides a lightweight disk-based database
that doesn't require a separate server process and allows accessing
the database using a nonstandard variant of the SQL query language.
Some applications can use SQLite for internal data storage.  It's also
possible to prototype an application using SQLite and then port the
code to a larger database such as PostgreSQL or Oracle.

%package modules-curses
Summary: Python3 "curses" module
Group: Development/Python3

%description modules-curses
An interface to the curses library, providing portable terminal
handling. The Curses module provides an interface to the curses library, the
de-facto standard for portable advanced terminal handling.
This extension module is designed to match the API of ncurses, an
open-source curses library hosted on Linux and the BSD variants of UNIX.

%package test
Summary: The test modules from the main python 3 package
Group: Development/Python3
Requires: %name = %EVR
Requires: %name-modules-tkinter = %EVR
Requires: %name-modules-curses = %EVR
Requires: %name-modules-sqlite3 = %EVR
Requires: %name-tools = %EVR
%add_python3_req_skip test.test_warnings.data msvcrt _winapi winreg
%add_python3_self_prov_path %buildroot%pylibdir/test/test_import/
%add_python3_self_prov_path %buildroot%pylibdir/test/regrtestdata/import_from_tests/test_regrtest_b/


%if 0%{?_python3_standalone:1}
# If we build python3 as standalone it requires python3.13(setuptools)
# which is not provided
%add_python3_req_skip setuptools
%endif

%description test
The test modules from the main %name package.
These are in a separate package to save space, as they are almost never used
in production.

You might want to install the python3-test package if you're developing
python 3 code that uses more than just unittest and/or test_support.py.

%if_with docs
%package doc
Summary: Documentation for the Python 3 programming language
Group: Documentation
BuildArch: noarch

%description doc
Documentation for the Python 3 programming language, interpreter,
and bundled module library in the HTML format.

%description doc -l ru_RU.UTF-8
Документация по языку программирования Python 3, его интерпретатору
и распространяемой с ним библиотеке модулей, в формате HTML.
%endif

%prep
%setup -n python3-%version

# Ensure that we're using the system copy of various libraries, rather than
# copies shipped by upstream in the tarball:
rm -r Modules/expat || exit 1
rm -r Modules/_decimal/libmpdec || exit 1

# Don't build upstream Python's implementation of these crypto algorithms;
# instead rely on _hashlib and OpenSSL.
#
# For example, in our builds hashlib.md5 is implemented within _hashlib via
# OpenSSL (and thus respects FIPS mode), and does not fall back to _md5
# TODO: there seems to be no OpenSSL support in Python for sha3 so far
# when it is there, also remove _sha3/ dir
#for f in md5module.c sha1module.c sha256module.c sha512module.c; do
#    rm Modules/$f
#done

# ALT Linux patches
%patch1003 -p2
%patch1004 -p2

%patch1005 -p2

%patch1007 -p2

%patch1011 -p2

%patch1012 -p2

%ifarch %e2k
# add e2k arch
sed -i "/elif defined(__hppa__)/i\\\n# elif defined (__e2k__)\n        e2k-linux-gnu" configure*
# unsupported profiling option
sed -i "s| -fprofile-correction||" configure*
# LCC profiling bug workaround
sed -i "/^Modules\\/_math.o:/{n;s|\$(CCSHARED) \$(PY_CORE_CFLAGS)|\$(filter-out -fprofile-generate-parallel,\$(CCSHARED) \$(PY_CORE_CFLAGS))|}" Makefile.pre.in
sed -i "s|-fprofile-generate|-fprofile-generate-parallel|" configure*
sed -i "s/rm -f profile-clean-stamp/&; eprof -s eprof.sum/" Makefile.pre.in
# exclude hanging tests
sed -i "s/^.*def test_stack_overflow(/    @unittest.skipIf(True, 'hangs')\n&/" Lib/test/test_faulthandler.py

# Faster interpreter on Elbrus:
# Patching with "sed" and "awk" gives more resilience against changes in
# Python sources. This patch tries to recreate the same optimization that
# was done using "computed gotos". But without using the GNU C extension
# "Labels as Values", the implementation of which is slow for the Elbrus
# compiler. This improves Python performance on Elbrus by about 10%.
# See ALT40278 for a detailed explanation.
sed -i "/#if USE_COMPUTED_GOTOS/{s|^|#undef USE_COMPUTED_GOTOS\n#define USE_COMPUTED_GOTOS 0\n|;:a;n;ba}" Python/ceval.c
sed -i "s|^ *EXTRA_CASES|default:Py_UNREACHABLE();&|" Python/ceval.c
%endif

# remove test_winreg() function
begin='^def .*winreg.*'
end='^[^[:blank:]]'
sed -re "/$begin/,/$end/ {
            /$begin/d;
            /$end/b;
            d
        }" \
    -i Lib/test/audit-tests.py

rm -fr ../build-shared
mkdir ../build-shared
cp -rl * ../build-shared/

# ======================================================
# Configuring and building the code:
# ======================================================
%build
build() {
%autoreconf
# Improves libpython performance, no effect on static build.
export CFLAGS_NODIST="-fno-semantic-interposition"
export LDFLAGS_NODIST="-fno-semantic-interposition"
# Note: "computed-gotos" are automatically detected by the configure script,
# must be turned off on e2k due to slow implementation.
%configure \
  --with-platlibdir=%{_lib} \
  --enable-ipv6 \
%ifnarch armh
  --enable-optimizations \
%endif
%ifarch %e2k
  --with-computed-gotos=no \
%endif
  --with-dbmliborder=gdbm:ndbm:bdb \
  --with-system-expat \
  --with-system-libmpdec \
  --enable-loadable-sqlite-extensions \
  --with-lto \
  --with-ssl-default-suites=openssl \
%if_with valgrind
  --with-valgrind \
%endif
  --without-ensurepip \
  $*

%make_build
}

pushd ../build-shared
build --enable-shared
popd

build

%if_with docs
sphinx-build-3 Doc html
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

# ======================================================
# Installing the built code:
# ======================================================
%install

# shared build only needed for libpython3
pushd ../build-shared
make install DESTDIR=%buildroot INSTALL="install -p"
popd

# static build is installed over shared because it's much faster
# the reason for such performance difference is unknown
find build -exec touch {} \;
make install DESTDIR=%buildroot INSTALL="install -p"

# Here we copy some config files to make python suggest to compile with shared
# library, not static. This can be verified by:
# python3 -c 'import sys ; import sysconfig ; sys.stdout.write(sysconfig.get_config_var("BLDLIBRARY"))'
# See more in ALT#40939
cp -av ../build-shared/Makefile %buildroot%pylibdir/config-%pybasever%pyabi-%pyarch/Makefile
cp -av ../build-shared/python-config %buildroot%_bindir/python3-config
cp -av ../build-shared/pyconfig.h %buildroot%include_dir
cp -av ../build-shared/build/lib.linux-*-%pybasever/_sysconfigdata__linux_%pyarch.py %buildroot%pylibdir

# Development tools
install -m755 -d %buildroot%tool_dir
install Tools/README %buildroot%tool_dir/
cp -ar Tools/freeze %buildroot%tool_dir/
cp -ar Tools/i18n %buildroot%tool_dir/
cp -ar Tools/unittestgui %buildroot%tool_dir/
cp -ar Tools/clinic %buildroot%tool_dir/

# Simple scripts
cp -ar Tools/scripts %buildroot%tool_dir/

# Documentation tools
install -m755 -d %buildroot%pylibdir/Doc
cp -ar Doc/tools %buildroot%pylibdir/Doc/

# python-gdb.py for gdb
mkdir -p %buildroot%gdb_auto_load
cp -a python-gdb.py %buildroot%gdb_auto_load/libpython%pybasever.so-gdb.py
cp -a python-gdb.py %buildroot%gdb_auto_load/python%pybasever-gdb.py

file_list='%tool_dir/*/*.py
    %tool_dir/scripts/pydoc*
    %tool_dir/scripts/idle*
    %pylibdir/*.py
    %pylibdir/test/*.py
    %pylibdir/test/*/*.py
    %pylibdir/turtledemo/*.py
    %pylibdir/idlelib/*.py'

for file_name in $file_list
do
    sed -i '1 i#!/usr/bin/env python%pybasever
    \@^#![[:space:]]*/usr/bin@d' %buildroot$file_name
    chmod +x %buildroot$file_name
done

install -d -m 0755 %buildroot%python3_sitelibdir/__pycache__
%if "%_lib" != "lib"
install -d -m 0755 %buildroot%python3_sitelibdir_noarch/__pycache__
%endif
# The install scripts put a README in the old-style %pylibdir/site-packages
# (actually, they copy the tree from the sources).
# So, we move it by force (like in rpm-build-python for other python3 packages,
# but in a more controlled way: we make sure that we know exactly what we copy,
# otherwise rmdir would fail):
%if 0%{?!_python3_standalone:1}
    mv -t %buildroot%python3_sitelibdir/ %buildroot%pylibdir/site-packages/README.txt
%else
    rm -rf %buildroot%pylibdir/site-packages/README.txt
%endif
rmdir %buildroot%pylibdir/site-packages

# For the list of architectures which has multilib support in ALT
# we make python3-devel multilib-ready (bug #192747, #139911)
%ifarch x86_64 %ix86
%global _pyconfig32_h pyconfig-32.h
%global _pyconfig64_h pyconfig-64.h

%ifarch x86_64
%global _pyconfig_h %_pyconfig64_h
%else
%global _pyconfig_h %_pyconfig32_h
%endif

mv %buildroot%include_dir/pyconfig.h  %buildroot%include_dir/%_pyconfig_h
cat > %buildroot%include_dir/pyconfig.h << EOF
#include <bits/wordsize.h>

#if __WORDSIZE == 32
#include "%_pyconfig32_h"
#elif __WORDSIZE == 64
#include "%_pyconfig64_h"
#else
#error "Unknown word size"
#endif
EOF

# Fix for bug 201434: make sure sysconfig looks at the right pyconfig.h file
# sysconfig.get_config_h_filename tries to locate pyconfig.h so it can be parsed,
# and needs to do this at runtime in site.py when python starts up (bug 653058)
#
# Split this out so it goes directly to the pyconfig-32.h/pyconfig-64.h
# variants:
sed -i -e "s/'pyconfig.h'/'%_pyconfig_h'/" \
  %buildroot%pylibdir/sysconfig/__init__.py
%else
%global _pyconfig_h pyconfig.h
%endif

# Remove shebang lines from .py files that aren't executable, and
# remove executability from .py files that don't have a shebang line:
find %buildroot -name \*.py \
  \( \( \! -perm /u+x,g+x,o+x -exec sed -e '/^#!/Q 0' -e 'Q 1' {} \; \
  -print -exec sed -i '1d' {} \; \) -o \( \
  -perm /u+x,g+x,o+x ! -exec grep -m 1 -q '^#!' {} \; \
  -exec chmod a-x {} \; \) \)

# Get rid of DOS batch files:
find %buildroot -name \*.bat -exec rm -v {} \;

# Get rid of backup files:
find %buildroot/ -name "*~" -exec rm -v {} \;
find . -name "*~" -exec rm -v {} \;

# Heal, not kill. ALT#49401
sed -i '1 { s|^#!/usr/bin/env python$|#!%_bindir/python3%{?_python3_standalone}|; t; Q 1; }' %buildroot%pylibdir/encodings/rot_13*.py

# http://bugs.python.org/issue26912 :
# rm another seemingly unused source file with a broken import:
rm -v %buildroot%pylibdir/test/test_email/{,__pycache__/}torture_test*.py*

# Get rid of win tests
rm -v %buildroot%pylibdir/test/{,__pycache__/}test_winreg*.py*
rm -v %buildroot%pylibdir/test/{,__pycache__/}test_winsound*.py*
rm -v %buildroot%pylibdir/test/{,__pycache__/}win_console_handler*.py*
rm -v %buildroot%pylibdir/test/test_importlib/{,__pycache__/}test_windows*.py*
rm -v %buildroot%pylibdir/test/libregrtest/{,__pycache__/}win_utils*.py*
# The libs which are being tested below have been excluded in %%files (long ago):
rm -v %buildroot%pylibdir/test/test_asyncio/{,__pycache__/}test_windows_events*.py*
rm -v %buildroot%pylibdir/test/test_asyncio/{,__pycache__/}test_windows_utils*.py*
rm -v %buildroot%pylibdir/test/{,__pycache__/}test_winconsoleio*.py*
# Get rid of bad* tests
rm -v %buildroot%pylibdir/test/test_future_stmt/bad*.py
# Get rid of crap
rm -v -r %buildroot%pylibdir/ctypes/macholib/fetch_macholib

%if_without tk
# Most files from modules-tkinter subpackage
rm -rv %buildroot%pylibdir/idlelib
rm -rv %buildroot%pylibdir/tkinter
rm -v  %buildroot%dynload_dir/_tkinter.cpython-%pyshortver%pyabi.so
rm -v  %buildroot%pylibdir/turtle.py
rm -v  %buildroot%pylibdir/test/test_turtle.py
rm -rv %buildroot%pylibdir/turtledemo
%endif

# Remove sphinxext (temporary)
rm -v -r %buildroot%pylibdir/Doc/tools/{extensions,static,templates}

# Fix end-of-line encodings:
find %buildroot/ -name \*.py -exec sed -i 's/\r//' {} \;

# Fixup permissions for shared libraries from non-standard 555 to standard 755:
find %buildroot \
    -perm 555 -exec chmod 755 {} \;

export LD_LIBRARY_PATH=%buildroot%_libdir
find %buildroot -type f -a -name "*.py" -a -not -wholename "*/test/*" -a -not -wholename "*/tests/*" -a -not -wholename "*/scripts/*" -print0 | xargs -0 %buildroot%_bindir/%name -c 'import py_compile, sys; [py_compile.compile(f, dfile=f.partition("%buildroot")[2]) for f in sys.argv[1:]]'
find %buildroot -type f -a -name "*.py" -a -not -wholename "*/test/*" -a -not -wholename "*/tests/*" -a -not -wholename "*/scripts/*" -print0 | xargs -0 %buildroot%_bindir/%name -O -c 'import py_compile, sys; [py_compile.compile(f, dfile=f.partition("%buildroot")[2]) for f in sys.argv[1:]]'

# Replace the shell implementation with the more correct .py one
# (BTW, the .py one used to be packaged in python3-3.3):
ln -sfv \
    "$(relative \
    %pylibdir/config-%pybasever%pyabi-%pyarch/python-config.py \
    %_bindir/python%pybasever%pyabi-config)" \
    %buildroot%_bindir/python%pybasever%pyabi-config

%global python_ignored_files site-packages(/.+\.(pth|egg-info(|/PKG-INFO|/entry_points\.txt|/namespace_packages\.txt)))?$
mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat > %buildroot%_sysconfdir/buildreqs/files/ignore.d/%name << EOF
^%_libdir/python3[^/]*/%python_ignored_files
%if "lib" != "%_lib"
^%prefix/lib/python3[^/]*/%python_ignored_files
%endif
EOF

mkdir -p %buildroot%_rpmlibdir
cat <<\EOF >%buildroot%_rpmlibdir/%name-base-files.req.list
# %name dirlist for %_rpmlibdir/files.req
%dynload_dir/	%name-base
%tool_dir/	%name-tools
EOF
# rpm-build-python3 has a dep on exactly this file with the list
# (for modularity: there used to be a separate package
# with these directories and the corresponding site customization):
%if 0%{?!_python3_standalone:1}
cat <<\EOF >%buildroot%_rpmlibdir/%python3_sitebasename-site-packages-files.req.list
%(dirname %python3_sitelibdir)	%name-base
%python3_sitelibdir/	%name-base
%if "%_lib" != "lib"
%(dirname %python3_sitelibdir_noarch)/	%name-base
%python3_sitelibdir_noarch/	%name-base
%endif
EOF
%endif

# Remove extra LICENSE file
rm -v %buildroot/%pylibdir/LICENSE.txt

# add idle3 to menu
cat >idle3.desktop <<EOF
%{expand:%(cat %SOURCE10)}
EOF
install -D -m 0644 Lib/idlelib/Icons/idle_16.png %buildroot%_datadir/icons/hicolor/16x16/apps/idle3%{?_python3_standalone}.png
install -D -m 0644 Lib/idlelib/Icons/idle_32.png %buildroot%_datadir/icons/hicolor/32x32/apps/idle3%{?_python3_standalone}.png
install -D -m 0644 Lib/idlelib/Icons/idle_48.png %buildroot%_datadir/icons/hicolor/48x48/apps/idle3%{?_python3_standalone}.png
%if_with desktop_file
desktop-file-install --dir=%buildroot%_datadir/applications %{?_python3_standalone:--vendor=%name} idle3.desktop
%endif

# We want to have clean bindir
rm -rf %buildroot%_bindir/__pycache__

# Force remove nis on e2k
%ifarch %e2k
rm -f %buildroot%dynload_dir/nis.cpython-%pyshortver%pyabi.so
%endif

# Clean after static build
rm -v %buildroot/%_libdir/libpython%pybasever%pyabi.a

%if 0%{?_python3_standalone:1}
# To avoid conflicts between python3 and python3.%submajor
    rm -rf %buildroot%_man1dir/python3.1
    rm -rf %buildroot%_bindir/pydoc3
# To avoid conflicts between python3-tools and python3.%submajor-tools
    rm -rf %buildroot%_bindir/idle3
# To avoid conflicts between python3 and python3.%submajor
    rm -rf %buildroot/%_bindir/python3
# To avoid duplicate provides for python3-dev and python3.%submajor-dev
    rm -rf %buildroot/%_libdir/pkgconfig/python3.pc
    rm -rf %buildroot/%_libdir/pkgconfig/python3-embed.pc
%endif

%check
# ALT#32008:
if head -1 %buildroot%_bindir/python3-config | fgrep -q python; then
configdir="$(
    WITHIN_PYTHON_RPM_BUILD= \
    LD_LIBRARY_PATH=$(pwd) \
    $(pwd)/python %buildroot%_bindir/python3-config --configdir)"
else
configdir="$(%buildroot%_bindir/python3-config --configdir)"
fi
[ -d %buildroot"$configdir" ]

# Ensure that the curses module was linked against libncursesw.so, rather than
# libncurses.so
# See https://bugzilla.redhat.com/show_bug.cgi?id=539917
ldd %{buildroot}/%{dynload_dir}/_curses*.so \
| grep curses \
| grep libncurses.so && {echo "_curses.so linked against libncurses.so"; exit 1 }

# See about locale: https://www.python.org/dev/peps/pep-0538/
export LANG=C

# Show some info, helpful for debugging test failures
LD_LIBRARY_PATH="$(pwd)" $(pwd)/python -m test.pythoninfo

# -l (--findleaks) is not compatible with -j
WITHIN_PYTHON_RPM_BUILD= \
LD_LIBRARY_PATH="$(pwd)" \
$(pwd)/python -m test.regrtest \
    -x test_socket -x test_signal \
    -i test_freeze_simple_script \
    -vwW --timeout=1800 %_smp_mflags

%files
%doc LICENSE README.rst
%_bindir/pydoc*
%_bindir/python3%{?_python3_standalone}
%{?!_python3_standalone:%_bindir/python%pybasever}
%_mandir/*/*
%gdb_auto_load/python*-gdb.py
%gdb_auto_load/__pycache__/python*-gdb.*.pyc

%files base
%doc LICENSE README.rst
%config %_sysconfdir/buildreqs/files/ignore.d/%name
%_rpmlibdir/%name-base-files.req.list
%{?!_python3_standalone:%_rpmlibdir/%python3_sitebasename-site-packages-files.req.list}

%{?!_python3_standalone:%dir %(dirname %python3_sitelibdir)}
%{?!_python3_standalone:%dir %python3_sitelibdir/}
%{?!_python3_standalone:%dir %python3_sitelibdir/__pycache__/}
%{?!_python3_standalone:%dir %python3_sitelibdir/README.txt}

%if "%_lib" != "lib"
%{?!_python3_standalone:%dir %(dirname %python3_sitelibdir_noarch)}
%{?!_python3_standalone:%dir %python3_sitelibdir_noarch/}
%{?!_python3_standalone:%dir %python3_sitelibdir_noarch/__pycache__/}
%endif

%dir %pylibdir
%dir %dynload_dir

%dynload_dir/_asyncio.cpython-%pyshortver%pyabi.so
%dynload_dir/_bisect.cpython-%pyshortver%pyabi.so
%dynload_dir/_blake2.cpython-%pyshortver%pyabi.so
%dynload_dir/_bz2.cpython-%pyshortver%pyabi.so
%dynload_dir/_codecs_cn.cpython-%pyshortver%pyabi.so
%dynload_dir/_codecs_hk.cpython-%pyshortver%pyabi.so
%dynload_dir/_codecs_iso2022.cpython-%pyshortver%pyabi.so
%dynload_dir/_codecs_jp.cpython-%pyshortver%pyabi.so
%dynload_dir/_codecs_kr.cpython-%pyshortver%pyabi.so
%dynload_dir/_codecs_tw.cpython-%pyshortver%pyabi.so
%dynload_dir/_contextvars.cpython-%pyshortver%pyabi.so
%dynload_dir/_csv.cpython-%pyshortver%pyabi.so
%dynload_dir/_ctypes.cpython-%pyshortver%pyabi.so
%dynload_dir/_datetime.cpython-%pyshortver%pyabi.so
%dynload_dir/_dbm.cpython-%pyshortver%pyabi.so
%dynload_dir/_decimal.cpython-%pyshortver%pyabi.so
%dynload_dir/_elementtree.cpython-%pyshortver%pyabi.so
%if_with gdbm
%dynload_dir/_gdbm.cpython-%pyshortver%pyabi.so
%endif
%dynload_dir/_hashlib.cpython-%pyshortver%pyabi.so
%dynload_dir/_heapq.cpython-%pyshortver%pyabi.so
%dynload_dir/_interpchannels.cpython-%pyshortver%pyabi.so
%dynload_dir/_interpqueues.cpython-%pyshortver%pyabi.so
%dynload_dir/_interpreters.cpython-%pyshortver%pyabi.so
%dynload_dir/_json.cpython-%pyshortver%pyabi.so
%dynload_dir/_lsprof.cpython-%pyshortver%pyabi.so
%dynload_dir/_lzma.cpython-%pyshortver%pyabi.so
%dynload_dir/_md5.cpython-%pyshortver%pyabi.so
%dynload_dir/_multibytecodec.cpython-%pyshortver%pyabi.so
%dynload_dir/_multiprocessing.cpython-%pyshortver%pyabi.so
%dynload_dir/_opcode.cpython-%pyshortver%pyabi.so
%dynload_dir/_pickle.cpython-%pyshortver%pyabi.so
%dynload_dir/_posixshmem.cpython-%pyshortver%pyabi.so
%dynload_dir/_posixsubprocess.cpython-%pyshortver%pyabi.so
%dynload_dir/_queue.cpython-%pyshortver%pyabi.so
%dynload_dir/_random.cpython-%pyshortver%pyabi.so
%dynload_dir/_sha1.cpython-%pyshortver%pyabi.so
%dynload_dir/_sha2.cpython-%pyshortver%pyabi.so
%dynload_dir/_sha3.cpython-%pyshortver%pyabi.so
%dynload_dir/_socket.cpython-%pyshortver%pyabi.so
%dynload_dir/_ssl.cpython-%pyshortver%pyabi.so
%dynload_dir/_statistics.cpython-%pyshortver%pyabi.so
%dynload_dir/_struct.cpython-%pyshortver%pyabi.so
%dynload_dir/_uuid.cpython-%pyshortver%pyabi.so
%dynload_dir/_zoneinfo.cpython-%pyshortver%pyabi.so
%dynload_dir/array.cpython-%pyshortver%pyabi.so
%dynload_dir/binascii.cpython-%pyshortver%pyabi.so
%dynload_dir/cmath.cpython-%pyshortver%pyabi.so
%dynload_dir/fcntl.cpython-%pyshortver%pyabi.so
%dynload_dir/grp.cpython-%pyshortver%pyabi.so
%dynload_dir/math.cpython-%pyshortver%pyabi.so
%dynload_dir/mmap.cpython-%pyshortver%pyabi.so
%dynload_dir/pyexpat.cpython-%pyshortver%pyabi.so
%dynload_dir/readline.cpython-%pyshortver%pyabi.so
%dynload_dir/resource.cpython-%pyshortver%pyabi.so
%dynload_dir/select.cpython-%pyshortver%pyabi.so
%dynload_dir/syslog.cpython-%pyshortver%pyabi.so
%dynload_dir/termios.cpython-%pyshortver%pyabi.so
%dynload_dir/unicodedata.cpython-%pyshortver%pyabi.so
%dynload_dir/zlib.cpython-%pyshortver%pyabi.so

%pylibdir/*.py
%dir %pylibdir/__pycache__/
%pylibdir/__pycache__/*%bytecode_suffixes

%dir %pylibdir/_pyrepl/
%dir %pylibdir/_pyrepl/__pycache__/
%pylibdir/_pyrepl/*.py
%pylibdir/_pyrepl/mypy.ini
%pylibdir/_pyrepl/__pycache__/*%bytecode_suffixes

%dir %pylibdir/asyncio/
%dir %pylibdir/asyncio/__pycache__/
%pylibdir/asyncio/*.py
%exclude %pylibdir/asyncio/windows_events.py
%exclude %pylibdir/asyncio/windows_utils.py
%pylibdir/asyncio/__pycache__/*%bytecode_suffixes
%exclude %pylibdir/asyncio/__pycache__/windows_events%bytecode_suffixes
%exclude %pylibdir/asyncio/__pycache__/windows_utils%bytecode_suffixes

%dir %pylibdir/collections/
%dir %pylibdir/collections/__pycache__/
%pylibdir/collections/*.py
%pylibdir/collections/__pycache__/*%bytecode_suffixes

%dir %pylibdir/concurrent/
%dir %pylibdir/concurrent/__pycache__/
%pylibdir/concurrent/*.py
%pylibdir/concurrent/__pycache__/*%bytecode_suffixes

%dir %pylibdir/concurrent/futures/
%dir %pylibdir/concurrent/futures/__pycache__/
%pylibdir/concurrent/futures/*.py
%pylibdir/concurrent/futures/__pycache__/*%bytecode_suffixes

%dir %pylibdir/ctypes/
%dir %pylibdir/ctypes/__pycache__/
%pylibdir/ctypes/*.py
%pylibdir/ctypes/__pycache__/*%bytecode_suffixes
%pylibdir/ctypes/macholib

%dir %pylibdir/dbm/
%dir %pylibdir/dbm/__pycache__/
%pylibdir/dbm/*.py
%pylibdir/dbm/__pycache__/*%bytecode_suffixes

%dir %pylibdir/email/
%dir %pylibdir/email/__pycache__/
%pylibdir/email/*.py
%pylibdir/email/__pycache__/*%bytecode_suffixes
%pylibdir/email/mime
%doc %pylibdir/email/architecture.rst

%pylibdir/encodings

%dir %pylibdir/ensurepip/
%dir %pylibdir/ensurepip/__pycache__/
%pylibdir/ensurepip/*.py
%pylibdir/ensurepip/__pycache__/*%bytecode_suffixes
%pylibdir/ensurepip/_bundled

%pylibdir/html
%pylibdir/http

%dir %pylibdir/importlib/
%dir %pylibdir/importlib/__pycache__/
%pylibdir/importlib/*.py
%pylibdir/importlib/__pycache__/*%bytecode_suffixes

%dir %pylibdir/importlib/metadata
%dir %pylibdir/importlib/metadata/__pycache__/
%pylibdir/importlib/metadata/*.py
%pylibdir/importlib/metadata/__pycache__/*%bytecode_suffixes

%dir %pylibdir/importlib/resources
%dir %pylibdir/importlib/resources/__pycache__/
%pylibdir/importlib/resources/*.py
%pylibdir/importlib/resources/__pycache__/*%bytecode_suffixes

%dir %pylibdir/json/
%dir %pylibdir/json/__pycache__/
%pylibdir/json/*.py
%pylibdir/json/__pycache__/*%bytecode_suffixes

%pylibdir/logging
%pylibdir/multiprocessing
%exclude %pylibdir/multiprocessing/popen_spawn_win32.py
%exclude %pylibdir/multiprocessing/__pycache__/popen_spawn_win32%bytecode_suffixes
%pylibdir/pydoc_data

%dir %pylibdir/pathlib/
%dir %pylibdir/pathlib/__pycache__/
%pylibdir/pathlib/*.py
%pylibdir/pathlib/__pycache__/*%bytecode_suffixes

%dir %pylibdir/re/
%dir %pylibdir/re/__pycache__/
%pylibdir/re/*.py
%pylibdir/re/__pycache__/*%bytecode_suffixes

%dir %pylibdir/sysconfig/
%dir %pylibdir/sysconfig/__pycache__/
%pylibdir/sysconfig/*.py
%pylibdir/sysconfig/__pycache__/*%bytecode_suffixes

%dir %pylibdir/tomllib/
%dir %pylibdir/tomllib/__pycache__/
%pylibdir/tomllib/*.py
%pylibdir/tomllib/mypy.ini
%pylibdir/tomllib/__pycache__/*%bytecode_suffixes

%if_with tk
%exclude %pylibdir/turtle.py
%exclude %pylibdir/__pycache__/turtle*%bytecode_suffixes
%endif

%dir %pylibdir/unittest/
%dir %pylibdir/unittest/__pycache__/
%pylibdir/unittest/*.py
%pylibdir/unittest/__pycache__/*%bytecode_suffixes

%pylibdir/urllib

%dir %pylibdir/venv/
%dir %pylibdir/venv/__pycache__/
%pylibdir/venv/*.py
%pylibdir/venv/__pycache__/*%bytecode_suffixes
%pylibdir/venv/scripts

%pylibdir/wsgiref
%pylibdir/xml
%pylibdir/xmlrpc

%dir %pylibdir/zoneinfo/
%dir %pylibdir/zoneinfo/__pycache__/
%pylibdir/zoneinfo/*.py
%pylibdir/zoneinfo/__pycache__/*%bytecode_suffixes

%dir %pylibdir/zipfile
%dir %pylibdir/zipfile/__pycache__/
%dir %pylibdir/zipfile/_path/
%dir %pylibdir/zipfile/_path/__pycache__/
%pylibdir/zipfile/*.py
%pylibdir/zipfile/__pycache__/*%bytecode_suffixes
%pylibdir/zipfile/_path/*.py
%pylibdir/zipfile/_path/__pycache__/*%bytecode_suffixes

# "Makefile" and the config-32/64.h file are needed by
# sysconfig.py:_init_posix(), so we include them in the core
# package, along with their parent directories (bug 531901):
%dir %pylibdir/config-%pybasever%pyabi-%pyarch/
%pylibdir/config-%pybasever%pyabi-%pyarch/Makefile
%dir %include_dir/
%include_dir/%_pyconfig_h

%files -n libpython3%{?_python3_standalone}
%_libdir/libpython%pybasever%pyabi.so.*
%gdb_auto_load/libpython*-gdb.py
%gdb_auto_load/__pycache__/libpython*-gdb.*.pyc

%files dev
%pylibdir/config-%pybasever%pyabi-%pyarch/*
%exclude %pylibdir/config-%pybasever%pyabi-%pyarch/Makefile
%include_dir/*.h
%dir %include_dir/cpython
%dir %include_dir/internal
%include_dir/internal/*.h
%dir %include_dir/internal/mimalloc
%dir %include_dir/internal/mimalloc/mimalloc
%include_dir/internal/mimalloc/*.h
%include_dir/internal/mimalloc/mimalloc/*.h
%include_dir/cpython/*.h
%exclude %include_dir/%_pyconfig_h
%doc Misc/README.valgrind Misc/valgrind-python.supp
%_bindir/python3-config
%_bindir/python%pybasever-config
%_libdir/libpython3.so
%_libdir/libpython%pybasever%pyabi.so
%{?!_python3_standalone:%_libdir/pkgconfig/python3.pc}
%_libdir/pkgconfig/python-%pybasever.pc
%_libdir/pkgconfig/python-%pybasever-embed.pc
%{?!_python3_standalone:%_libdir/pkgconfig/python3-embed.pc}

%files tools
%_bindir/idle*
%if_with desktop_file
%_desktopdir/%{?_python3_standalone:%name-}idle3.desktop
%endif
%_miconsdir/idle3%{?_python3_standalone}.png
%_niconsdir/idle3%{?_python3_standalone}.png
%_liconsdir/idle3%{?_python3_standalone}.png

%tool_dir
%doc %pylibdir/Doc

%if_with tk
%files modules-tkinter
%pylibdir/idlelib
%exclude %pylibdir/idlelib/idle_test
%pylibdir/tkinter
%dynload_dir/_tkinter.cpython-%pyshortver%pyabi.so
%pylibdir/turtle.py
%pylibdir/__pycache__/turtle*%bytecode_suffixes
%dir %pylibdir/turtledemo
%pylibdir/turtledemo/*.py
%pylibdir/turtledemo/*.cfg
%dir %pylibdir/turtledemo/__pycache__/
%pylibdir/turtledemo/__pycache__/*%bytecode_suffixes
%endif

%files modules-sqlite3
%dir %pylibdir/sqlite3/
%dir %pylibdir/sqlite3/__pycache__/
%pylibdir/sqlite3/*.py
%pylibdir/sqlite3/__pycache__/*%bytecode_suffixes
%dynload_dir/_sqlite3.cpython-%pyshortver%pyabi.so

%files modules-curses
%pylibdir/curses
%dynload_dir/_curses.cpython-%pyshortver%pyabi.so
%dynload_dir/_curses_panel.cpython-%pyshortver%pyabi.so

%files test
%pylibdir/test

%dir %pylibdir/__phello__/
%dir %pylibdir/__phello__/__pycache__/
%pylibdir/__phello__/*.py
%pylibdir/__phello__/__pycache__/*%bytecode_suffixes

%dynload_dir/_ctypes_test.cpython-%pyshortver%pyabi.so
%dynload_dir/_testbuffer.cpython-%pyshortver%pyabi.so
%dynload_dir/_testcapi.cpython-%pyshortver%pyabi.so
%dynload_dir/_testclinic.cpython-%pyshortver%pyabi.so
%dynload_dir/_testclinic_limited.cpython-%pyshortver%pyabi.so
%dynload_dir/_testexternalinspection.cpython-%pyshortver%pyabi.so
%dynload_dir/_testimportmultiple.cpython-%pyshortver%pyabi.so
%dynload_dir/_testinternalcapi.cpython-%pyshortver%pyabi.so
%dynload_dir/_testlimitedcapi.cpython-%pyshortver%pyabi.so
%dynload_dir/_testmultiphase.cpython-%pyshortver%pyabi.so
%dynload_dir/_testsinglephase.cpython-%pyshortver%pyabi.so
%dynload_dir/_xxtestfuzz.cpython-%pyshortver%pyabi.so
%dynload_dir/xxlimited.cpython-%pyshortver%pyabi.so
%dynload_dir/xxlimited_35.cpython-%pyshortver%pyabi.so
%dynload_dir/xxsubtype.cpython-%pyshortver%pyabi.so
%if_with tk
%pylibdir/idlelib/idle_test
%endif

%if_with docs
%files doc
%doc html/*
%endif

%changelog
