%define qdoc_found %{expand:%%(if [ -e %_qt5_bindir/qdoc ]; then echo 1; else echo 0; fi)}
%add_verify_elf_skiplist %_qt5_libdir/libQt5WebKit.so.*
%add_verify_elf_skiplist %_qt5_libdir/libQt5WebKitWidgets.so.*

%define optflags_lto %nil
%global qt_module qtwebkit
%def_disable bootstrap

Name: qt5-webkit
Version: 5.212.0
Release: alt28

Group: System/Libraries
Summary: Qt5 - QtWebKit components
License: LGPL-2.1-or-later and BSD-3-Clause
Url: http://qt.io/
Source: %qt_module-everywhere-src-%version.tar

# FC
Patch1: webkit-offlineasm-warnings-ruby27.patch
Patch2: qtwebkit-5.212.0_cmake_cmp0071.patch
Patch3: qtwebkit-5.212.0-add-riscv64.patch
Patch4: qtwebkit-fix-build-gcc14.patch
Patch5: qtwebkit-icu68.patch
Patch6: qtwebkit-icu76.patch
# ALT
Patch10: alt-flags.patch
# Elbrus
Patch2000: qtwebkit-e2k.patch
# LoongArch
Patch3500: qtwebkit-loongarch64.patch

# Automatically added by buildreq on Mon Sep 30 2013 (-bi)
# optimized out: elfutils fontconfig glib2-devel glibc-devel-static gstreamer-devel libGL-devel libX11-devel libXfixes-devel libfreetype-devel libgst-plugins libqt5-core libqt5-gui libqt5-network libqt5-opengl libqt5-printsupport libqt5-qml libqt5-quick libqt5-sql libqt5-v8 libqt5-widgets libstdc++-devel libxml2-devel pkg-config python-base python-modules python-modules-compiler python-modules-encodings python-modules-xml python3 python3-base qt5-base-devel qt5-declarative-devel ruby ruby-stdlibs xorg-compositeproto-devel xorg-fixesproto-devel xorg-renderproto-devel xorg-xproto-devel zlib-devel
#BuildRequires: flex fontconfig-devel gcc-c++ gperf gst-plugins-devel libXcomposite-devel libXext-devel libXrender-devel libgio-devel libicu-devel libjpeg-devel libpng-devel libsqlite3-devel libudev-devel libwebp-devel libxslt-devel perl-Term-ANSIColor python-module-distribute python-module-simplejson qt5-webkit-devel rpm-build-python3 rpm-build-ruby zlib-devel-static
BuildRequires(pre): rpm-macros-qt5
%if_disabled bootstrap
BuildRequires(pre): qt5-tools
%endif
BuildRequires: cmake
BuildRequires: flex fontconfig-devel gcc-c++ libicu-devel libjpeg-devel libpng-devel
BuildRequires: libsqlite3-devel libudev-devel libwebp-devel libxslt-devel libpcre-devel gperf
BuildRequires: pkgconfig(glib-2.0) pkgconfig(gio-2.0)
# pkgconfig(gstreamer-1.0) pkgconfig(gstreamer-plugins-base-1.0) pkgconfig(gstreamer-app-1.0)
BuildRequires: libXcomposite-devel libXext-devel libXrender-devel libdrm-devel
# libGL-devel
#BuildRequires: python-module-distribute python-module-simplejson python-module-json rpm-build-python
BuildRequires: python-module-distribute python-module-json rpm-build-python
BuildRequires: ruby ruby-libs
BuildRequires: perl(Term/ANSIColor.pm) perl(Perl/Version.pm) perl(Digest/Perl/MD5.pm)
BuildRequires: zlib-devel libxml2-devel
#BuildRequires: libleveldb-devel
BuildRequires: qt5-base-devel qt5-xmlpatterns-devel qt5-declarative-devel qt5-webchannel-devel
#qt5-location-devel qt5-multimedia-devel qt5-sensors-devel

%description
%summary

%package common
Summary: Common package for %name
Group: System/Configuration/Other
BuildArch: noarch
Requires: qt5-base-common
%description common
Common package for %name

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
Requires: %name-common = %EVR
Requires: qt5-base-devel
Requires: qt5-declarative-devel
%description devel
%summary.

%package doc
Summary: Document for developing apps which will use Qt5 %qt_module
Group: Development/KDE and QT
BuildArch: noarch
Requires: %name-common = %EVR
%description doc
This package contains documentation for Qt5 %qt_module

%package -n libqt5-webkit
Group: System/Libraries
Summary: Qt5 library
Requires: %name-common = %EVR
Requires: libqt5-core = %_qt5_version
%description -n libqt5-webkit
%summary

%package -n libqt5-webkitwidgets
Group: System/Libraries
Summary: Qt5 library
Requires: %name-common = %EVR
Requires: libqt5-core = %_qt5_version
%description -n libqt5-webkitwidgets
%summary


%prep
%setup -n %qt_module-everywhere-src-%version
%patch1 -p1
%patch2 -p1
%ifnarch %e2k
%patch3 -p1
%endif
%patch4 -p1
%patch5 -p1
%patch6 -p1
#
%patch10 -p1
%ifarch %e2k
%patch2000 -p1
%endif
%ifnarch %e2k
%patch3500 -p1
%endif
syncqt.pl-qt5 Source -version %version

# remove rpath
#find ./ -type f -name \*.pr\* | \
#while read f; do
#    sed -i 's|\(^CONFIG[[:space:]][[:space:]]*+=[[:space:]].*\)rpath|\1|' $f
#    sed -i 's|\([[:space:]]CONFIG[[:space:]][[:space:]]*+=[[:space:]].*\)rpath|\1|' $f
#done

# fix linking
#echo 'QMAKE_LIBS_OPENGL += -lpthread' >> Source/api.pri

%build
%ifarch riscv64
export LDFLAGS="${LDFLAGS:-} -Wl,--no-as-needed -latomic"
%endif
%ifarch %e2k
# because of this error on linking:
# "relocation truncated to fit: R_E2K_32_ABS"
%define optflags_debug -g0
%else
%define optflags_debug -g1
%endif
%add_optflags -fpermissive
export LDFLAGS="$LDFLAGS -Wl,--no-keep-memory"
%if_disabled bootstrap
export QT_HASH_SEED=0
%endif
export QT_INSTALL_DOCS="%_qt5_docdir"
export QT_VER="%_qt5_version" QT_VERSION="%_qt5_version"
export QT_VERSION_TAG=`echo "%_qt5_version" | sed 's|\.||g'`
export BUILDDIR="$PWD"
export CMAKE_POLICY_VERSION_MINIMUM="3.5"
#    -DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
cmake \
    -DCMAKE_INSTALL_PREFIX=%_qt5_prefix \
    -DCMAKE_SKIP_RPATH:BOOL=ON \
    -DCMAKE_SKIP_INSTALL_RPATH:BOOL=ON \
    -DKDE_INSTALL_INCLUDEDIR:PATH=%_qt5_headerdir \
    -DKDE_INSTALL_LIBEXECDIR:PATH=%_qt5_libexecdir \
    -DKDE_INSTALL_LIBDIR:PATH=%_qt5_libdir \
    -DKDE_INSTALL_QMLDIR=%_qt5_qmldir \
    -DPORT=Qt \
    -DCMAKE_BUILD_TYPE=Release \
    -DENABLE_TOOLS=OFF \
    -DCMAKE_C_FLAGS_RELEASE:STRING="%optflags -DNDEBUG" \
    -DCMAKE_CXX_FLAGS_RELEASE:STRING="%optflags -DNDEBUG" \
    -DUSE_LD_GOLD=OFF \
    \
    -DUSE_GSTREAMER=OFF \
    -DUSE_QT_MULTIMEDIA=OFF \
    -DENABLE_GEOLOCATION=OFF \
    -DENABLE_DEVICE_ORIENTATION=OFF \
    -DENABLE_NETSCAPE_PLUGIN_API=OFF \
    -DUSE_LIBHYPHEN=OFF \
    -DUSE_WOFF2=OFF \
    -DENABLE_INSPECTOR_UI=OFF \
    -DENABLE_LINK_PREFETCH=OFF \
    \
%ifnarch %arm aarch64 %ix86 x86_64
    -DENABLE_JIT=OFF \
%endif
%ifnarch %arm aarch64 %ix86 x86_64
    -DUSE_SYSTEM_MALLOC=ON \
%endif
%if_disabled bootstrap
    -DGENERATE_DOCUMENTATION=ON \
%endif
    #
[ "%__nprocs" != 1 ] || export NPROCS=3
%make_build

%install
export QT_INSTALL_DOCS="%_qt5_docdir"
export QT_VER="%_qt5_version" QT_VERSION="%_qt5_version"
export QT_VERSION_TAG=`echo "%_qt5_version" | sed 's|\.||g'`
export BUILDDIR="$PWD"
%make install DESTDIR=%buildroot
%install_qt5_post_qt
%install_qt5_post_common

find %buildroot/%_libdir/cmake/ -type f -name \*.cmake | \
while read f ; do
    sed -i 's|${_IMPORT_PREFIX}/../../\([[:alpha:]]\)|/usr/\1|g' $f
done

%files common
%doc Source/WebCore/LICENSE*

%files doc
%if_disabled bootstrap
%if %qdoc_found
%_qt5_docdir/*
%endif
%endif

%files -n libqt5-webkit
%_qt5_libdir/libQt5WebKit.so.*
%_qt5_libexecdir/QtWeb?*Process
%_qt5_archdatadir/qml/QtWebKit/

%files -n libqt5-webkitwidgets
%_qt5_libdir/libQt5WebKitWidgets.so.*
%_qt5_libexecdir/QtWebProcess

%files devel
%_qt5_headerdir/Qt*/
%_qt5_libdir/libQt*.so
%_qt5_libdatadir/libQt*.so
#%_qt5_libdir/libQt*.prl
#%_qt5_libdatadir/libQt*.prl
%_qt5_libdir/cmake/Qt*/
%_qt5_archdatadir/mkspecs/modules/*.pri
%_pkgconfigdir/Qt*.pc

%changelog
