# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: qtermwidget
Version: 1.4.0
Release: alt1

Summary: unicode-enabled, embeddable QT5 terminal widget
License: GPL-2.0-or-later
Group: Terminals

Url: https://github.com/lxqt/qtermwidget
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++
BuildRequires: qt5-base-devel qt5-tools-devel
BuildRequires: lxqt-build-tools

%description
QTermWidget is an opensource project based on KDE Konsole
application. The main goal of this project is to provide
unicode-enabled, embeddable Qt5 widget for using as a built-in
console (or terminal emulation widget).

Of course I'm aware about embedding abilities of original
Konsole, but once I had Qt without KDE, and it was a serious
problem.

0.4.0+ is a friendly fork, the original project is still available
at http://qtermwidget.sourceforge.net/

%package data
Summary: unicode-enabled, embeddable Qt5 terminal widget shared data
Group: Terminals
BuildArch: noarch
Conflicts: qtermwidget-qt5-data < 0.8.0

%description data
QTermWidget is an opensource project based on KDE Konsole
application. The main goal of this project is to provide
unicode-enabled, embeddable Qt5 widget for using as a built-in
console (or terminal emulation widget).

This package contains the shared data.

%package -n lib%name
Summary: unicode-enabled, embeddable Qt5 terminal widget library
Group: System/Libraries
Requires: %name-data = %EVR
Conflicts: libqtermwidget-qt5 < 0.8.0

%description -n lib%name
This package contains the shared library for %name.

%package -n lib%name-devel
Summary: unicode-enabled, embeddable Qt5 terminal widget library
Group: Development/KDE and QT
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains the development headers for %name library.

%prep
%setup

%build
%cmake
%cmake_build

%install
%cmake_install

%files

%files data
%_datadir/%{name}*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%doc AUTHORS LICENSE README*
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/*/

%changelog
