%define py_fname python3-module-ranger

Name: ranger
Version: 1.9.3
Release: alt1

Summary(ru_RU.UTF-8): Консольный файл-менеджер
Summary: Console file manager
License: GPLv3
Group: File tools
Url: https://ranger.github.io/

BuildArch: noarch

Source0: %name-%version.tar.gz

BuildRequires(pre): python3-dev
Requires: %py_fname = %version-%release

%description
ranger is a free console file manager that gives you greater
flexibility and a good overview of your files without having to leave
your *nix console. It visualizes the directory tree in two dimensions:
the directory hierarchy on one, lists of files on the other, with a
preview to the right so you know where you'll be going.

%description -l ru_RU.UTF-8
Свободный файловый менеджер, который дает вам большую гибкость и
хороший обзор ваших файлов без необходимости покидать консоль. Он
визуализирует дерево каталогов в двух измерениях: иерархия директорий
в одном и список файлов на другом, с возможностью предпросмотра.

%package -n %py_fname
Summary: Supplemental module for %name, %summary
Group: Development/Python3

%description -n %py_fname
%summary

%prep
%setup

grep -rl '#!.*python' * | xargs sed -i 's@\(#!.*\)python@\1python3@'
grep -rl ' python ' ranger | egrep '[.](conf|sh)' | xargs sed -i 's@ python @ python3 @g'
grep -rl ' pygmentize ' ranger | xargs sed -i 's@ pygmentize @ pygmentize3 @g'


%build
%python3_build

%install
%python3_install

%files
%_bindir/*
%doc %_defaultdocdir/%name
%_man1dir/*
%_desktopdir/%name.desktop

%files -n %py_fname
%python3_sitelibdir/*

%changelog
