%def_with inotify
%def_without fam
%def_enable qtgui
%def_disable webkit

%define pre %nil

Name: recoll
Version: 1.39.2
Release: alt1

Summary: A personal full text search package
Summary(ru_RU.UTF-8): Программа для полнотекстового поиска по файлам с различными форматами.
License: GPLv2+
Group: File tools

Url: http://recoll.org
Source0: %url/%name-%version%pre.tar.gz
# lrelease-qt5 recoll_ru.ts *and* uncomment cp below
Source1: recoll_ru.ts
Source2: recoll_ru.qm
Source3: recoll_uk.ts
Source4: recoll_uk.qm
# 1.24.1+ru
Source5: recoll-searchgui.desktop
Source100: recoll.watch

Patch: recoll-alt-default-8bit-encoding-for-ru.patch

Packager: Michael Shigorin <mike@altlinux.org>
BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ libaspell-devel ImageMagick
%{?_with_fam:BuildRequires: libfam-devel}
BuildRequires: libxapian-devel >= 0.9
BuildRequires: rpm-build-licenses
BuildRequires: perl-Image-ExifTool
BuildRequires: zlib-devel
BuildRequires: libaspell-devel
BuildRequires: libchm-devel
BuildRequires: libxslt-devel
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: rpm-build-python3
BuildRequires: chrpath libxdf-devel findutils liblzma-devel
BuildRequires: meson rpm-macros-meson cmake libmagic-devel libmagic

%if_enabled qtgui
BuildRequires: qt6-base-devel qt6-tools qt6-svg-devel qt6-tools-devel qt6-qtbase-gui libqt6-gui libXt-devel xorg-cf-files
#qt5-base-devel qt5-x11extras-devel qt5-tools-devel libXt-devel xorg-cf-files
%if_enabled webkit
#BuildRequires: qt5-webkit-devel
%endif
%endif

%add_findreq_skiplist %_datadir/%name/filters/*
%add_findreq_skiplist %_datadir/%name/examples/*

%description
Recoll is a personal full-text search package based on a very powerful
Xapian backend, for which it provides an easy to use, feature-rich,
easy administration interface.

See also recoll-extras package for somewhat more exotic stuff.
%if_disabled qtgui

Note that this package has been built without its usual GUI.
%endif

%description -l ru_RU.UTF-8
Recoll - это персональный пакет полнотекстового поиска, основанный на очень
мощном движке Xapian, для которого он предоставляет простой в использовании,
многофункциональный, простой интерфейс администрирования.

Смотрите также пакет recoll-extras для более сложных вещей.
%if_disabled qtgui

Обратите внимание, что этот пакет был собран без его привычного графического
интерфейса.
%endif

%package devel
Summary: Development headers for Recoll
Group: Development/C++
Requires: %name = %version-%release

%description devel
This package contains library headers needed to link against librecoll.

%description -l ru_RU.UTF-8 devel
Этот пакет содержит библиотечные заголовки для связывания с librecoll.

%package extras
Summary: More helper scripts for Recoll
Group: File tools
Requires: %name = %version
BuildArch: noarch

%description extras
This package contains additional helper scripts for recoll which might
need bulky additional required packages, manual setup, or both.

%description -l ru_RU.UTF-8 extras
Этот пакет содержит дополнительные вспомогательные скрипты для recoll,
которые могут потребовать громоздких дополнительных пакетов, ручной установки
или и того и другого.

%package full
Summary: All the recommended stuff for Recoll
Group: File tools
BuildArch: noarch
Requires: %name-extras = %version
Requires: perl-Image-ExifTool
Requires: antiword unrtf wv
Requires: python3-module-%name
Requires: python3-module-pychm python3-module-lxml
Requires: aspell aspell-ru-rk
Requires: xpdf-utils ghostscript-utils
Requires: mutagen


%description full
This package contains just the requirements for additional packages
that might be of use with Recoll.

%description -l ru_RU.UTF-8 full
Этот пакет содержит в себе все требуемые элементы для дополнительных пакетов,
которые могут быть полезны при работе с Recoll.

%package -n python3-module-%name
Summary: Python bindings for Recoll
Group: Development/Python3
Obsoletes: python-module-%name

%description -n python3-module-%name
This package contains Python bindings for Recoll.

%description -l ru_RU.UTF-8 -n python3-module-%name
Этот пакет содержит привязки языка Python для Recoll.

%prep
%setup -n %name-%version%pre
%patch0 -p2

sed -i 's/openoffice/loffice/' sampleconf/mimeview
sed -i '/^Categories=/s/=/=Qt;/' desktop/*.desktop
# updated translations: ru
#cp -a %SOURCE1 %SOURCE2 qtgui/i18n/
cp -a %SOURCE5 desktop/

%build
export CXXFLAGS="%optflags" PATH="$PATH:%_libdir/qt6/bin"
export QMAKE=qmake-qt6


%meson \
      -Dwebkit=false 
#      -DRECOLL_QT6_BUILD=1 \
#      -DRECOLL_ENABLE_WEBENGINE=1

# 1.38.{0,1} often fails to link given enough cores available;
# meson-based build is race-prone here (cf. #348496 try 1/2)
%meson_build || %meson_build

gzip --best --keep --force ChangeLog
for s in 128 96 72 64 36 32 24 22 16; do
    convert -depth 8 -resize ${s}x$s desktop/%name{.xcf,-$s.png}
done

%install
%meson_install

for s in 128 96 72 64 36 32 24 22 16; do
    install -pDm644 desktop/%name-$s.png %buildroot%_iconsdir/hicolor/${s}x$s/apps/%name.png
done
sed -i 's/xterm/xvt/g' %buildroot%_datadir/%name/filters/*

# use /usr/bin/xdg-open
rm -f %buildroot%_datadir/%name/filters/xdg-open

# help rpm-build-python3 get over this (thx andy@)
sed -i "s|#!/usr/bin/env python3|#!%__python3|" \
	%buildroot%_datadir/%name/filters/*.py

# as of 1.36.0
chrpath -d %buildroot%_bindir/recollindex

%files
%_bindir/*
# librecoll gets installed with no soname on intent: no ABI warranty
%_libdir/lib%{name}.so.*
%_datadir/%name
%exclude %_datadir/%name/filters/rcllyx
%exclude %_datadir/%name/filters/*.py
%exclude %_datadir/%name/filters/*.zip
%if_enabled qtgui
%_datadir/metainfo/*
%_iconsdir/hicolor/*/apps/*
%_pixmapsdir/*
%_desktopdir/*
%endif
%_libexecdir/systemd/user/recollindex.service
%_libexecdir/systemd/system/recoll*.service
%_man1dir/*
%_man5dir/*
%doc ChangeLog.* README

%files devel
%_libdir/lib%{name}.so
%_includedir/%name/

%files extras
%_datadir/%name/filters/rcllyx
%_datadir/%name/filters/*.py
%_datadir/%name/filters/*.zip

%files full

%files -n python3-module-%name
#python3_sitelibdir/*.egg-info
%python3_sitelibdir/%name/
%python3_sitelibdir/recollchm/
%python3_sitelibdir/*.so

%changelog
