%define _unpackaged_files_terminate_build 1
%def_without telepathy
%def_with kwallet
%def_with gvnc
%def_with x2go
%def_with freerdp3

Name: remmina
Version: 1.4.41
Release: alt1
Summary: Remote Desktop Client

Group: Networking/Remote access
License: GPLv2+ and MIT
Url: http://remmina.sourceforge.net
Source: %name-%version.tar
#Source1: ru.po
Patch0: %name-%version.patch

Requires: icon-theme-hicolor

Obsoletes: %name-plugins-nx < %EVR
Obsoletes: %name-plugins-st < %EVR
Obsoletes: %name-plugins-xdmcp < %EVR

BuildRequires(pre): cmake >= 3.4.0
BuildRequires: gcc-c++
BuildRequires: python3-dev
BuildRequires: desktop-file-utils xdg-utils
BuildRequires: gettext libcurl-devel pkgconfig(libpcre2-8) pkgconfig(libffi)
BuildRequires: intltool
BuildRequires: libappstream-glib
BuildRequires: libgcrypt-devel libssl-devel
BuildRequires: libjpeg-devel libtasn1-devel libpng-devel libpixman-devel zlib-devel
BuildRequires: pkgconfig(glib-2.0) >= 2.30 pkgconfig(gio-2.0) pkgconfig(gobject-2.0) pkgconfig(gmodule-2.0) pkgconfig(gthread-2.0)
BuildRequires: pkgconfig(avahi-ui-gtk3) >= 0.6.30 pkgconfig(avahi-client) >= 0.6.30
%if_with freerdp3
BuildRequires: xfreerdp3 libfreerdp3-devel libwinpr3-devel libfuse3-devel
%else
BuildRequires: xfreerdp libfreerdp-devel libwinpr-devel
%endif
BuildRequires: libcups-devel
BuildRequires: pkgconfig(gtk+-3.0) >= 3.14.0 pkgconfig(gdk-pixbuf-2.0) pkgconfig(pango)
BuildRequires: pkgconfig(atk)
BuildRequires: pkgconfig(cairo)
BuildRequires: pkgconfig(wayland-client) pkgconfig(wayland-cursor) pkgconfig(wayland-egl) pkgconfig(wayland-scanner) pkgconfig(xkbcommon)
BuildRequires: pkgconfig(libsecret-1)
%{?_with_kwallet:BuildRequires: kf5-kwallet-devel}
BuildRequires: pkgconfig(libssh) >= 0.6
BuildRequires: pkgconfig(libvncserver) pkgconfig(libvncclient)
%{?_with_gvnc:BuildRequires: pkgconfig(gvnc-1.0) pkgconfig(gvncpulse-1.0) pkgconfig(gtk-vnc-2.0)}
%{?_with_telepathy:BuildRequires: pkgconfig(telepathy-glib) pkgconfig(dbus-glib-1)}
%{?_with_x2go:BuildRequires: pyhoca-cli}
BuildRequires: pkgconfig(vte-2.91)
BuildRequires: pkgconfig(xkbfile)
BuildRequires: pkgconfig(harfbuzz)
BuildRequires: pkgconfig(spice-client-gtk-3.0)
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(libsoup-3.0) pkgconfig(webkit2gtk-4.1)
BuildRequires: pkgconfig(libsodium)
BuildRequires: pkgconfig(ayatana-appindicator3-0.1)

%add_findreq_skiplist %_datadir/%name/external_tools/*

%description
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny netbooks.

Remmina supports multiple network protocols in an integrated and consistent
user interface. Currently RDP, VNC, XDMCP and SSH are supported

%package devel
Summary: remmina development headers
Group: Development/Other

%description devel
Files required to build plugins for remmina

%package plugins
Summary: A set of plugins for remmina
Group: Networking/Remote access
BuildArch: noarch

Requires: %name
Requires: %name-plugins-exec
Requires: %name-plugins-secret
Requires: %name-plugins-rdp
Requires: %name-plugins-vnc
Requires: %name-plugins-spice

%description plugins
A set of plugins for %name remote desktop client

%package plugins-exec
Summary: External execution plugin for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR

%description plugins-exec
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the plugin to execute external processes (commands or
applications) from the Remmina window.

%package plugins-secret
Summary: Keyring integration for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR
Provides: %name-plugins-gnome = %EVR
Obsoletes: %name-plugins-gnome < %EVR

%description plugins-secret
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the plugin with keyring support for the Remmina remote
desktop client.

%package plugins-kwallet
Summary: Kwallet integration for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR

%description plugins-kwallet
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the plugin with kwallet support for the Remmina remote
desktop client.

%package plugins-rdp
Summary: RDP plugin for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR

%description plugins-rdp
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the Remote Desktop Protocol (RDP) plugin for the Remmina
remote desktop client.

%package plugins-vnc
Summary: VNC plugin for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR

%description plugins-vnc
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the VNC plugin for the Remmina remote desktop
client.

%package plugins-gvnc
Summary: GTK-VNC plugin for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR

%description plugins-gvnc
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the GTK-VNC plugin for the Remmina remote desktop
client.

%package plugins-spice
Summary: SPICE plugin for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR

%description plugins-spice
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the SPICE plugin for the Remmina remote desktop
client.

%package plugins-www
Summary: WWW plugin for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR

%description plugins-www
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the WWW plugin (web browser with authentication) for the
Remmina remote desktop client.

%package plugins-x2go
Summary: X2GO plugin for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR
Requires: pyhoca-cli

%description plugins-x2go
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the X2GO plugin for the Remmina remote desktop
client.

%package plugins-python
Summary: Pyhton plugin for Remmina Remote Desktop Client
Group: Networking/Remote access
Requires: %name = %EVR

%description plugins-python
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains the python plugin for the Remmina remote desktop client.

%package gnome-session
Summary: Gnome Shell session for Remmina kiosk mode
Group: Networking/Remote access
BuildArch: noarch
Requires: %name = %EVR
Requires: gnome-session

%description gnome-session
Remmina is a remote desktop client written in GTK+, aiming to be useful for
system administrators and travelers, who need to work with lots of remote
computers in front of either large monitors or tiny net-books.

This package contains Remmina kiosk mode, including a Gnome Shell session
that shows up under the display manager session menu.

%prep
%setup
%patch0 -p1

#cp -f %%SOURCE1 po/

%build
%cmake \
    -DCMAKE_BUILD_TYPE=Release \
    -DWITH_NEWS=OFF \
    -DWITH_APPINDICATOR=OFF \
    -DWITH_AVAHI=ON \
    -DWITH_FREERDP=ON \
     %{?_with_freerdp3:-DWITH_FREERDP3=ON} \
    -DWITH_GCRYPT=ON \
    -DWITH_GETTEXT=ON \
    -DWITH_LIBSSH=ON \
     %{?_without_telepathy:-DWITH_TELEPATHY=OFF} \
    -DWITH_VTE=ON \
    -DWITH_KIOSK_SESSION=ON \
    %{?_with_gvnc:-DWITH_GVNC=ON} \
    %{?_with_x2go:-DWITH_X2GO=ON} \
    %{?_with_kwallet:-DWITH_KF5WALLET=ON} \
    -DWITH_PYTHON=ON \
    -DREMMINA_RUNTIME_PLUGINDIR=%_libdir/remmina/plugins \
    -DREMMINA_PLUGINDIR=%_libdir/remmina/plugins

%cmake_build

%install
%cmakeinstall_std

mkdir -p %buildroot%_pkgconfigdir
install -p -m 644 data/%name.pc.in %buildroot%_pkgconfigdir/%name.pc

subst "s|@prefix@|%prefix|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@exec_prefix@|%_exec_prefix|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@libdir@|%_libdir|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@includedir@|%_includedir|g" %buildroot%_pkgconfigdir/%name.pc
subst "s|@VERSION@|%version|g" %buildroot%_pkgconfigdir/%name.pc

%find_lang %name

%files -f %name.lang
%doc AUTHORS CHANGELOG.md README.md
%_bindir/%name
%_bindir/remmina-file-wrapper
%_datadir/metainfo/*.appdata.xml
%_datadir/mime/*/*.xml
%_datadir/applications/*.desktop
%_iconsdir/hicolor/*/actions/*
%_iconsdir/hicolor/*/apps/*
%_iconsdir/hicolor/apps/*
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-ssh-symbolic.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-sftp-symbolic.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-tool-symbolic.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-status-green.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-status-grey.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-status-red.svg
%_iconsdir/hicolor/*/status/org.remmina.Remmina-status.svg
%_datadir/%name
%_man1dir/remmina.1.*
%_man1dir/remmina-file-wrapper.1.*
%dir %_libdir/remmina
%dir %_libdir/remmina/plugins

%files plugins
%files plugins-exec
%_libdir/remmina/plugins/remmina-plugin-exec.so

%files plugins-secret
%_libdir/remmina/plugins/remmina-plugin-secret.so

%if_with kwallet
%files plugins-kwallet
%_libdir/remmina/plugins/remmina-plugin-kwallet.so
%endif

%files plugins-rdp
%_libdir/remmina/plugins/remmina-plugin-rdp.so
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-rdp-ssh-symbolic.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-rdp-symbolic.svg

%files plugins-vnc
%_libdir/remmina/plugins/remmina-plugin-vnc.so
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-vnc-ssh-symbolic.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-vnc-symbolic.svg

%if_with gvnc
%files plugins-gvnc
%_libdir/remmina/plugins/remmina-plugin-gvnc.so
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-gvnc-ssh-symbolic.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-gvnc-symbolic.svg
%endif

%files plugins-spice
%_libdir/remmina/plugins/remmina-plugin-spice.so
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-spice-ssh-symbolic.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-spice-symbolic.svg

%files plugins-www
%_libdir/remmina/plugins/remmina-plugin-www.so
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-www-symbolic.svg

%if_with x2go
%files plugins-x2go
%_libdir/remmina/plugins/remmina-plugin-x2go.so
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-x2go-ssh-symbolic.svg
%_iconsdir/hicolor/*/emblems/org.remmina.Remmina-x2go-symbolic.svg
%endif

%files plugins-python
%_libdir/remmina/plugins/remmina-plugin-python_wrapper.so

%files gnome-session
%_bindir/gnome-session-remmina
%_bindir/remmina-gnome
%_datadir/gnome-session/sessions/remmina-gnome.session
%_datadir/xsessions/remmina-gnome.desktop
%_man1dir/gnome-session-remmina.1.*
%_man1dir/remmina-gnome.1.*

%files devel
%_includedir/%name
%_pkgconfigdir/*

%changelog
