Name: rpminstall-tests
Version: 1.1.3
Release: alt8

Summary: Tests for rpm: how it interprets packages when installing

BuildRequires(pre): rpm-build-licenses
License: %gpl2plus
Group: Development/Tools
Url: http://git.altlinux.org/people/imz/packages/rpminstall-tests.git

BuildArch: noarch

%global REQS make tmpdir.sh rpm-build rpm
Requires: %REQS
# For %%check, whcih is called %%build in this pkg because of the e2k Girar:
BuildRequires: %REQS

Source: %name-%version.tar

%description
Tests for rpm: how it interprets packages when installing.

Now, it tests how various forms of constraints (Requires, Conflicts, Obsoletes)
are interpreted when they are installed together with packages with
various forms of matching Provides.

More tests can appear.

%package checkinstall
Summary: Immediately run %name when installing this package
Group: Other
Requires(pre): %name

%description checkinstall
Immediately run %name when installing this package.

They test rpm (applied to the results of rpm-build).

%package archcompat-checkinstall
Summary: Immediately run arch_compat %name when installing this package
Group: Other
Requires(pre): %name

%description archcompat-checkinstall
Immediately run a few arch_compat RPM tests when installing this package.

They test rpm -i, applied to the results of rpmbuild, which is used
to build packages without explicitly specifying the architecture, so
that their architecture is derived automatically based on `uname -m`.

%package archcompat-with-proc-checkinstall
Summary: Immediately run arch_compat %name when installing this package (with /proc)
Group: Other
Requires(pre): /proc
# to be sure:
Requires: /proc
Requires(pre): %name

%description archcompat-with-proc-checkinstall
Immediately run a few arch_compat RPM tests when installing this package
(with /proc).

They test rpm -i, applied to the results of rpmbuild, which is used
to build packages without explicitly specifying the architecture, so
that their architecture is derived automatically based on `uname -m`.

%prep
%setup

%install
mkdir -p %buildroot%_datadir/%name
install -m0644 Makefile HELPER *.mk -t %buildroot%_datadir/%name/
install -m0755 makeme.sh -t %buildroot%_datadir/%name/

# Normally, this would be %%check,
# but it's convenient for me to do this check also in the e2k Girar,
# where --without check is enabled. Turn this back into %%check in future.
%build
# We don't use %%make_build to pass the usual parallelism flags
# to avoid parallelism with possible nasty races
# (until a good implementation is in place in our makefiles):
%global _makeme ./makeme.sh

%define simple_test \
echo 'Simple test (to fail fast):'\
%_makeme %{?opts} TESTS=dummy_installable\
%_makeme %{?opts} clean\
%nil

%define archcompat_test \
echo 'Simple arch_compat tests (between `uname -m`, rpmbuild, and rpm -i):'\
echo 'diagnostics'\
uname -a ||:\
cat /proc/cpuinfo ||:\
LD_SHOW_AUXV=1 /bin/echo ||:\
cat %_sysconfdir/rpm/platform ||:\
rpm --eval %%_host_cpu ||:\
rpm --eval %%_arch ||:\
\
system_arch="$(rpm -q rpm --qf='%%{ARCH}')"\
echo "...with a package built for the system rpm's arch ($system_arch):"\
%_makeme %{?opts} TESTS=dummy_installable minimal_arch= TESTS_TARGET="$system_arch"\
%_makeme %{?opts} clean\
\
default_arch="$(rpmbuild --eval %%_arch ||:)"\
echo "...with a package built for the machine's default arch ($default_arch):"\
%_makeme %{?opts} TESTS=dummy_installable minimal_arch= ||\
    case "$default_arch" in\
        arm*)\
            echo 'ARM arch detection is not ideal in rpm-build;'\
            echo 'IGNORING THE FAILURE until better times.'\
            ;;\
        *)\
            false\
            ;;\
    esac\
%_makeme %{?opts} clean\
%nil

%define all_tests \
echo 'Main tests:'\
%_makeme %{?opts}\
echo 'Now test also with "Epoch: 0" instead of no Epoch:'\
%_makeme %{?opts} clean\
%_makeme %{?opts} minimal_epoch=0\
%nil

%simple_test
%archcompat_test
%all_tests

%files
%_datadir/%name

# Set this value for all scritplets that follow:
%global _makeme %_datadir/%name/makeme.sh

%files checkinstall

%pre checkinstall -p %_sbindir/sh-safely
set -x
mkdir "$TMPDIR/home"
HOME="$TMPDIR/home"; export HOME
%simple_test
%all_tests

%files archcompat-checkinstall

%pre archcompat-checkinstall -p %_sbindir/sh-safely
set -x
mkdir "$TMPDIR/home"
HOME="$TMPDIR/home"; export HOME
%archcompat_test
%simple_test

%files archcompat-with-proc-checkinstall

%pre archcompat-with-proc-checkinstall -p %_sbindir/sh-safely
set -x
mkdir "$TMPDIR/home"
HOME="$TMPDIR/home"; export HOME
%archcompat_test
%simple_test

%changelog
