Name: rsync
Version: 3.2.7
Release: alt3
%define srcname rsync-%version

Summary: A program for synchronizing files over a network
License: GPLv3+
Group: Networking/File transfer
Url: https://rsync.samba.org

# git://git.altlinux.org/gears/r/rsync.git
Source: %name-%version-%release.tar

BuildRequires: libacl-devel
BuildRequires: libattr-devel
BuildRequires: liblz4-devel
BuildRequires: libpopt-devel
BuildRequires: libssl-devel
BuildRequires: libxxhash-devel
BuildRequires: libzstd-devel
BuildRequires: python3-module-commonmark

%package server
Summary: Server environment for the rsync program
Group: System/Servers
BuildArch: noarch
Requires: %name = %version-%release

%description
Rsync uses a quick and reliable algorithm to very quickly bring
remote and host files into sync.  Rsync is fast because it just
sends the differences in the files over the network (instead of
sending the complete files).  Rsync is often used as a very powerful
mirroring process or just as a more capable replacement for the
rcp command.  A technical report which describes the rsync algorithm
is included in this package.

%description server
Rsync uses a quick and reliable algorithm to very quickly bring
remote and host files into sync.  Rsync is fast because it just
sends the differences in the files over the network (instead of
sending the complete files).  Rsync is often used as a very powerful
mirroring process or just as a more capable replacement for the
rcp command.  A technical report which describes the rsync algorithm
is included in this package.

This package includes rsyncd daemon functionality.

%prep
%setup -n %name-%version-%release

%build
./prepare-source
%add_optflags -fno-strict-aliasing
%configure \
	--enable-lz4 \
	--enable-openssl \
	--enable-xxhash \
	--enable-zstd \
	--enable-acl-support \
	--enable-xattr-support \
	--with-nobody-user=rsyncd \
	--with-nobody-group=rsyncd \
	#
%make_build

%install
%makeinstall_std INSTALLCMD='install -p' INSTALLMAN='install -p'
install -pD -m640 packaging/lsb/rsync.xinetd \
	%buildroot%_sysconfdir/xinetd.d/rsync
install -pD -m600 rsyncd.conf \
	%buildroot%_sysconfdir/rsyncd.conf
install -pD -m640 rsyncd.logrotate \
	%buildroot%_sysconfdir/logrotate.d/rsyncd
install -pD /dev/null %buildroot%_logdir/rsyncd/rsyncd.log
mkdir -p %buildroot%_unitdir
install -pm644 rsyncd.socket rsyncd@.service \
	%buildroot%_unitdir/
install -Dpm644 /dev/null %buildroot%_sysconfdir/sysconfig/rsyncd

%check
make -k check

%post server
/usr/sbin/groupadd -r -f rsyncd
/usr/sbin/useradd -r -g rsyncd -d /dev/null -s /dev/null \
	-c 'The rsync daemon' -n rsyncd >/dev/null 2>&1 ||:

%triggerpostun server -- %name
for f in %_sysconfdir/rsyncd.conf %_sysconfdir/xinetd.d/rsync; do
	if [ ! -f "$f" ]; then
		if [ -f "$f.rpmsave" ]; then
			cp -pf "$f.rpmsave" "$f"
		elif [ -f "$f.rpmnew" ]; then
			cp -pf "$f.rpmnew" "$f"
		fi
	fi
done

%files
%_bindir/*
%_man1dir/*
%doc support/ tech_report.tex NEWS.md README.md

%files server
%config(noreplace) %_sysconfdir/logrotate.d/rsyncd
%config(noreplace) %_sysconfdir/xinetd.d/rsync
%config(noreplace) %_sysconfdir/rsyncd.conf
%_unitdir/rsyncd.socket
%_unitdir/rsyncd@.service
%ghost %config(noreplace,missingok) %_sysconfdir/sysconfig/rsyncd
%_man5dir/*
%attr(750,root,adm) %dir %_logdir/rsyncd
%ghost %attr(640,root,adm) %verify(not md5 mtime size) %_logdir/rsyncd/rsyncd.log

%changelog
