%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define pypi_name ruff

%define bash_completionsdir %_datadir/bash-completion/completions
%define fish_completionsdir %_datadir/fish/vendor_completions.d
%define zsh_completionsdir %_datadir/zsh/site-functions

Name: %pypi_name
Version: 0.11.6
Release: alt1

Summary: An extremely fast Python linter, written in Rust
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/ruff/
Vcs: https://github.com/astral-sh/ruff

Source0: %name-%version.tar
Source1: vendor.tar
Source2: config.toml
Source3: %pyproject_deps_config_name

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
BuildRequires: rust
BuildRequires: rust-cargo
BuildRequires: /proc
BuildRequires: libjemalloc-devel
BuildRequires: libzstd-devel

%description
%summary.

%package -n python3-module-%pypi_name
Summary: An extremely fast Python linter, written in Rust (Python package)
Group: Development/Python3
BuildArch: noarch
Requires: %pypi_name = %EVR

%description -n python3-module-%pypi_name
%summary.

%prep
%setup -a1
install -v %SOURCE2 .cargo/config.toml
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

# do not ship dependencies lists
rm -rv docs/requirements*.txt docs/.gitignore docs/.overrides

%build
%ifarch aarch64
# aarch64 needs this flag to avoid the following building errors:
#    - undefined reference to `__aarch64_swp1_acq'
#    - undefined reference to `__aarch64_cas1_acq_rel'
export CFLAGS="$CFLAGS -mno-outline-atomics"
%endif
%ifarch i586
# i586 needs this flag to avoid the following building error:
#    - undefined reference to '__stack_chk_fail_local'
export CFLAGS="$CFLAGS -fno-stack-protector"
%endif
%pyproject_build

%install
%pyproject_install

chmod 755 %buildroot%_bindir/%pypi_name

mkdir -p %buildroot%bash_completionsdir
mkdir -p %buildroot%fish_completionsdir
mkdir -p %buildroot%zsh_completionsdir

%buildroot%_bindir/%pypi_name generate-shell-completion bash \
    > %buildroot%bash_completionsdir/%pypi_name
%buildroot%_bindir/%pypi_name generate-shell-completion fish \
    > %buildroot%fish_completionsdir/%pypi_name.fish
%buildroot%_bindir/%pypi_name generate-shell-completion zsh \
    > %buildroot%zsh_completionsdir/_%pypi_name

# move python-module to noarch-directory
%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
mkdir -p %buildroot%python3_sitelibdir_noarch
mv %buildroot%python3_sitelibdir/* %buildroot%python3_sitelibdir_noarch/
%endif

%files
%doc LICENSE README.md BREAKING_CHANGES.md docs
%_bindir/%pypi_name
%bash_completionsdir/%pypi_name
%fish_completionsdir/%pypi_name.fish
%zsh_completionsdir/_%pypi_name

%files -n python3-module-%pypi_name
%python3_sitelibdir_noarch/%pypi_name/
%python3_sitelibdir_noarch/%{pyproject_distinfo %pypi_name}/

%changelog
