%define _unpackaged_files_terminate_build 1

Summary: Tool to manage your infrastructure
Name: salt
Version: 3007.5
Release: alt1
License: Apache-2.0
Group: System/Configuration/Other
URL: http://saltstack.org
VCS: https://github.com/saltstack/salt

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildArch: noarch

Source0: %name-%version.tar
Source1: master.logrotate
Source2: minion.logrotate
Source3: salt-api.init
Source4: salt-master.init
Source5: salt-minion.init
Source6: salt-syndic.init

Patch1: salt-alt-supported-names.patch
Patch2: salt-alt-minion-KillMode.patch
Patch3: salt-minion-fix-search-sls.patch

AutoReq: yes, noshell

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools perl-podlators
BuildRequires: libzeromq-devel
BuildRequires: python3-module-msgpack python3-module-yaml
BuildRequires: python3-module-distro
BuildRequires: python3-module-wheel
BuildRequires: python3-module-importlib-metadata

# Control module version for 3006.6
BuildRequires: python3-module-cryptography >= 41.0.7
BuildRequires: python3-module-urllib3 >= 2.0.6
BuildRequires: python3-module-pycryptodome >= 3.19.1
BuildRequires: python3-module-pycryptodomex >= 3.19.1
BuildRequires: python3-module-GitPython >= 3.1.41
BuildRequires: python3-module-jinja2 >= 3.1.4

%add_python3_req_skip win32api win32event win32service win32serviceutil winerror pythoncom distutils ntsecuritycon win32con win32process win32security vsanmgmtObjects requests.packages.urllib3.util.ssl_

# pyrax.exceptions is a not a real dependency: pyrax
# presence is gated at salt/utils/openstack/pyrax/__init__.py
%add_python3_req_skip pyrax.exceptions

# For more detailed autoreqs (under jnpr.*), which can be satisfied;
# this fixes the general UNMET python2.X(jnpr), which used to appear.
%python3_req_hier
# except "virtual" Provides of six.py, which cannot be autogenerated:
# {0} is to strip a space at the end:
%filter_from_requires s:salt\.ext\.::g

%description
Salt is a distributed remote execution system used to execute commands
and query data. It was developed in order to bring the best solutions
found in the world of remote execution together and make them better,
faster and more malleable. Salt accomplishes this via its ability to
handle larger loads of information, and not just dozens, but hundreds,
or even thousands of individual servers. It handles them quickly and
through a simple yet manageable interface.

%package -n python3-module-salt
Summary: Management component for salt, a parallel remote execution system
Group: Development/Python
Obsoletes: python-module-salt 
%py3_requires yaml msgpack pycryptodomex contextvars
AutoReq: yes, noshell

%description  -n python3-module-salt
Salt is a distributed remote execution system used to execute commands
and query data. It was developed in order to bring the best solutions
found in the world of remote execution together and make them better,
faster and more malleable. Salt accomplishes this via its ability to
handle larger loads of information, and not just dozens, but hundreds,
or even thousands of individual servers. It handles them quickly and
through a simple yet manageable interface.

%package master
Summary: Management component for salt, a parallel remote execution system
Group: System/Configuration/Other
Requires: python3-module-salt = %version-%release
AutoReq: yes, noshell

%description master
The Salt master is the central server to which all minions connect.

%package minion
Summary: Client component for salt, a parallel remote execution system
Group: System/Configuration/Other
Requires: python3-module-salt = %version-%release
AutoReq: yes, noshell

%description minion
Salt minion is queried and controlled from the master.

%package api
Summary: API for salt
Group: System/Configuration/Other
Requires: python3-module-salt = %version-%release
AutoReq: yes, noshell

%description api
salt-api is a modular interface on top of Salt that can provide
a variety of entry points into a running Salt system. It can start
and manage multiple interfaces allowing a REST API to coexist
with XMLRPC or even a Websocket API.

%prep
%setup
%autopatch -p1
# Current Salt version from sources
echo -n '%version' > salt/_version.txt
# Remove local copy documentation mention
subst 's| file:///usr/share/doc/salt/html/contents.html||' pkg/common/*.service
# Proper sysctl -w use: http://bugzilla.altlinux.org/47289
sed -i 's/_sysctl, "-w"/_sysctl, "-v", "-w"/' salt/modules/linux_sysctl.py
# Set correct python3 executable in shebang
subst 's|#!.*python$|#!%__python3|' $(grep -Rl '#!.*python$' salt/*)
subst 's|/usr/local/bin/python2.7|%__python3|' salt/cloud/deploy/bootstrap-salt.sh

%build
%pyproject_build

%install
%pyproject_install

# Add some directories
install -d -m 0755 %buildroot%_var/log/salt
touch %buildroot%_var/log/salt/minion
touch %buildroot%_var/log/salt/master
install -d -m 0755 %buildroot%_var/cache/salt
install -d -m 0755 %buildroot%_sysconfdir/salt
install -d -m 0755 %buildroot%_sysconfdir/salt/master.d
install -d -m 0755 %buildroot%_sysconfdir/salt/minion.d
install -d -m 0755 %buildroot%_sysconfdir/salt/pki
install -d -m 0755 %buildroot%_sysconfdir/salt/pki/master
install -d -m 0755 %buildroot%_sysconfdir/salt/pki/minion
install -d -m 0755 %buildroot%_sysconfdir/salt/cloud.conf.d
install -d -m 0755 %buildroot%_sysconfdir/salt/cloud.deploy.d
install -d -m 0755 %buildroot%_sysconfdir/salt/cloud.maps.d
install -d -m 0755 %buildroot%_sysconfdir/salt/cloud.profiles.d
install -d -m 0755 %buildroot%_sysconfdir/salt/cloud.providers.d
install -d -m 0755 %buildroot%_sysconfdir/salt/proxy.d

install -D -m 755 %SOURCE4 %buildroot%_initdir/salt-master
install -D -m 755 %SOURCE6 %buildroot%_initdir/salt-syndic
install -D -m 755 %SOURCE5 %buildroot%_initdir/salt-minion
install -D -m 755 %SOURCE3 %buildroot%_initdir/salt-api

mkdir -p %buildroot%_unitdir
install -p -m 0644 pkg/common/salt-master.service %buildroot%_unitdir/
install -p -m 0644 pkg/common/salt-syndic.service %buildroot%_unitdir/
install -p -m 0644 pkg/common/salt-minion.service %buildroot%_unitdir/
install -p -m 0644 pkg/common/salt-api.service %buildroot%_unitdir/
install -p -m 0644 pkg/common/salt-proxy@.service %buildroot%_unitdir/

mkdir -p %buildroot%_sysconfdir/salt/
install -p -m 0640 conf/minion %buildroot%_sysconfdir/salt/minion
install -p -m 0640 conf/master %buildroot%_sysconfdir/salt/master
install -p -m 0640 conf/cloud  %buildroot%_sysconfdir/salt/cloud
install -p -m 0640 conf/roster %buildroot%_sysconfdir/salt/roster
install -p -m 0640 conf/proxy  %buildroot%_sysconfdir/salt/proxy

mkdir -p %buildroot%_sysconfdir/sysconfig
echo "ARG=''" >  %buildroot%_sysconfdir/sysconfig/salt-master
echo "ARG=''" >  %buildroot%_sysconfdir/sysconfig/salt-syndic
echo "ARG=''" >  %buildroot%_sysconfdir/sysconfig/salt-minion
echo "ARG=''" >  %buildroot%_sysconfdir/sysconfig/salt-api

install -D -m 0644 pkg/rpm/salt.bash %buildroot%_sysconfdir/bash_completion.d/salt

install -D -m 0644 %SOURCE1 %buildroot%_sysconfdir/logrotate.d/salt-master
install -D -m 0644 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/salt-minion

%post master
%post_service salt-master
%post_service salt-syndic

%preun master
%preun_service salt-master
%preun_service salt-syndic

%post minion
%post_service salt-minion

%preun minion
%preun_service salt-minion

%post api
%post_service salt-api

%preun api
%preun_service salt-api

%files -n python3-module-salt
%doc AUTHORS README*
%config(noreplace) %dir %_sysconfdir/salt
%config(noreplace) %dir %_sysconfdir/salt/pki
%python3_sitelibdir/*
%_man7dir/salt.7.*

%files master
%config(noreplace) %_sysconfdir/salt/master
%config(noreplace) %_sysconfdir/salt/master.d
%config(noreplace) %_sysconfdir/salt/roster
%config %_sysconfdir/bash_completion.d/*
%config(noreplace) %dir %_sysconfdir/bash_completion.d
%config(noreplace) %_sysconfdir/logrotate.d/salt-master
%config(noreplace) %_sysconfdir/salt/pki/master
%config(noreplace) %_sysconfdir/sysconfig/salt-master
%config(noreplace) %_sysconfdir/sysconfig/salt-syndic
%_sysconfdir/salt/cloud.conf.d
%_sysconfdir/salt/cloud.deploy.d
%_sysconfdir/salt/cloud.maps.d
%_sysconfdir/salt/cloud.profiles.d
%_sysconfdir/salt/cloud.providers.d
%config(noreplace) %_sysconfdir/salt/cloud
%ghost %_logdir/salt/master
%_var/cache/salt
%_initdir/salt-master
%_initdir/salt-syndic
%_unitdir/salt-master.service
%_unitdir/salt-syndic.service
%_bindir/salt
%_bindir/salt-cloud
%_bindir/salt-cp
%_bindir/salt-key
%_bindir/salt-master
%_bindir/salt-pip
%_bindir/salt-run
%_bindir/salt-ssh
%_bindir/salt-syndic
%_bindir/spm
%_man1dir/salt.1.*
%_man1dir/salt-master.1.*
%_man1dir/salt-cp.1.*
%_man1dir/salt-cloud.1.*
%_man1dir/salt-key.1.*
%_man1dir/salt-run.1.*
%_man1dir/salt-syndic.1.*
%_man1dir/salt-ssh.1.*
%_man1dir/spm.1.*

%files api
%config(noreplace) %_sysconfdir/sysconfig/salt-api
%_bindir/salt-api
%_initdir/salt-api
%_unitdir/salt-api.service
%_man1dir/salt-api.1.*

%files minion
%config(noreplace) %_sysconfdir/salt/minion
%config(noreplace) %_sysconfdir/salt/minion.d
%config(noreplace) %_sysconfdir/salt/proxy
%config(noreplace) %_sysconfdir/logrotate.d/salt-minion
%config(noreplace) %_sysconfdir/sysconfig/salt-minion
%config(noreplace) %_sysconfdir/salt/pki/minion
%ghost %_logdir/salt/minion
%_initdir/salt-minion
%_unitdir/salt-minion.service
%_unitdir/salt-proxy@.service
%_bindir/salt-call
%_bindir/salt-minion
%_bindir/salt-proxy
%_man1dir/salt-call.1.*
%_man1dir/salt-minion.1.*
%_man1dir/salt-proxy.1.*

%changelog
