Group: Development/Java
AutoReq: yes,noosgi
BuildRequires: rpm-build-java-osgi
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# should be consistent across one release
%global build_date 20130405

Name:           sat4j
Version:        2.3.5
Release:        alt1_20jpp11
Summary:        A library of SAT solvers written in Java

License:        EPL-1.0 or LGPLv2
URL:            http://www.sat4j.org/
# Created by sh sat4j-fetch.sh
Source0:        sat4j-%{version}.tar.xz
Source1:        sat4j-fetch.sh

Patch0:         0001-Fix-runtime-classpath-and-minimum-BREE.patch

BuildRequires:  ant
BuildRequires:  javapackages-local

BuildArch:      noarch
Source44: import.info

%description
The aim of the SAT4J library is to provide an efficient library of SAT
solvers in Java. The SAT4J library targets first users of SAT "black
boxes", those willing to embed SAT technologies into their application
without worrying about the details.

%prep
%setup -q -n sat4j-%{version}
%patch0 -p1

%build
export ANT_OPTS="-Dfile.encoding=iso-8859-1"
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -Dbuild.compiler=modern -Drelease=%{version} \
 -Dtarget=1.8 -Dsource=1.8 -DBUILD_DATE=%{build_date} p2

%mvn_artifact "org.ow2.sat4j:org.ow2.sat4j.core::%{version}" dist/%{version}/org.sat4j.core.jar
%mvn_artifact "org.ow2.sat4j:org.ow2.sat4j.pb::%{version}" dist/%{version}/org.sat4j.pb.jar
%mvn_file ":org.ow2.sat4j.core" org.sat4j.core
%mvn_file ":org.ow2.sat4j.pb" org.sat4j.pb

%install
%mvn_install

%files -f .mfiles
# No %%doc files as the about.html is in the jar

%changelog
