%define _unpackaged_files_terminate_build 1

%global import_path gitlab.com/stone.code/scov

Name: scov
Version: 0.11.0
Release: alt1

Summary: Generate reports on code coverage using gcov, lcov, or llvm-cov
License: BSD-3-Clause
Group: Development/Other
Url: https://pkg.go.dev/gitlab.com/stone.code/scov
Vcs: https://gitlab.com/stone.code/scov

Source: %name-%version.tar
Patch0: scov-0.11.0-alt-wordwrap-for-filename.patch

ExclusiveArch: %go_arches
BuildRequires(pre): rpm-build-golang

%description
SCov collects code coverage data generated by instrumented binaries, using
either gcov or llvm-cov, and then generates reports on the data. There is a
simple text report that calculates the line coverage and function coverage for
all of the source files (example, or markdown). For more detailed information,
there is an HTML report (example). The HTML report includes line coverage,
function coverage, branch coverage, and region coverage. Annotated source files
are also created (example).

SCov is also quite a bit faster than lcov for generating reports. Timing was
measured for two sample projects, which had sizes of 0.3kloc and 10kloc. It is
only a few points, but the measurements show that SCov should be more than 30x
faster. For smaller code bases, lcov also has a significant start-up cost.

%prep
%setup
%patch0 -p1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export LDFLAGS="-X main.versionInformation=%version"

%golang_prepare

cd .build/src/%import_path
%golang_build .

%install
export BUILDDIR="$PWD/.build"
export IGNORE_SOURCES=1
%golang_install

%files
%doc LICENSE README.md
%_bindir/*

%changelog
