Name: sdcc
Version: 4.4.0
Release: alt1
Epoch: 1

Summary: Small Device C Compiler
License: GPLv2
Group: Development/C
Url: http://sdcc.sourceforge.net

Source: %name-%version.tar

BuildRequires: rpm-build-python3
BuildRequires: flex gcc-c++ boost-devel gputils >= 1.5.2
BuildRequires: zlib-devel

Requires: %name-common = %EVR

%description
SDCC is a free open source, retargettable, optimizing ANSI C compiler
suite that targets a growing list of processors including the Intel
MCS51 based microprocessors (8031, 8032, 8051, 8052, etc.), Maxim
(formerly Dallas) DS80C390 variants, Freescale (formerly Motorola)
HC08 based (hc08, s08) and Zilog Z80 based MCUs (z80, z180, gbz80,
Rabbit 2000/3000, Rabbit 3000A). Work is in progress on supporting
the Microchip PIC16 and PIC18 targets. It can be retargeted for other
microprocessors.

%package common
License: GPLv2 LGPLv2
Group:   Development/C
Summary: Libraries and Header Files for the SDCC C compiler

%description common
SDCC is a free open source, retargettable, optimizing ANSI C compiler
suite that targets a growing list of processors including the Intel
MCS51 based microprocessors (8031, 8032, 8051, 8052, etc.), Maxim
(formerly Dallas) DS80C390 variants, Freescale (formerly Motorola)
HC08 based (hc08, s08) and Zilog Z80 based MCUs (z80, z180, gbz80,
Rabbit 2000/3000, Rabbit 3000A). Work is in progress on supporting
the Microchip PIC16 and PIC18 targets. It can be retargeted for other
microprocessors.

%package doc
Group:     Development/C
Summary:   Documentation for the SDCC C compiler
BuildArch: noarch

%description doc
SDCC is a free open source, retargettable, optimizing ANSI C compiler
suite that targets a growing list of processors including the Intel
MCS51 based microprocessors (8031, 8032, 8051, 8052, etc.), Maxim
(formerly Dallas) DS80C390 variants, Freescale (formerly Motorola)
HC08 based (hc08, s08) and Zilog Z80 based MCUs (z80, z180, gbz80,
Rabbit 2000/3000, Rabbit 3000A). Work is in progress on supporting
the Microchip PIC16 and PIC18 targets. It can be retargeted for other
microprocessors.

%global _configure_detect_runstatedir %nil

%prep
%setup
find support -type f |xargs grep -l 'env python' |\
	xargs sed -ri '/^#!\/usr\/bin\/env python$/ s,env python,python3,'
sed -ri '/^extern char \*(copying|warranty)/ s,char ,const char ,' \
	sim/ucsim/globals.h

%build
%configure \
	--docdir=%_docdir/%name-%version \
	--enable-werror=no \
	%nil

%make_build sdcc-sdbinutils
%make_build

%install
%makeinstall_std STRIP=:
rm -vf %buildroot%_man1dir/serialview*

%brp_strip_none %_datadir/sdcc/*

%files 
%_bindir/*
%_libexecdir/sdcc
%_man1dir/ucsim.1*

%files common
%_datadir/%name

%files doc
%_docdir/%name-%version

%changelog
