Name: seafile
Version: 9.0.14
Release: alt1

Summary: Full-fledged cloud storage platform

Group: Networking/File transfer
License: GPLv2 with permissions for OpenSSL
Url: https://github.com/haiwen/seafile

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/haiwen/seafile/archive/v%version.tar.gz
Source: %name-%version.tar

Source1: README.ALT.utf8.txt
Source2: nginx.conf.example

Patch: seafile-curl-7.62.patch

BuildRequires(pre): rpm-build-python3

BuildRequires: intltool libuuid-devel
BuildRequires: vala

BuildRequires: libsqlite3-devel >= 3.7

BuildRequires: libssl-devel

# see configure.ac
BuildRequires: pkgconfig(glib-2.0) >= 2.16.0
BuildRequires: pkgconfig(gobject-2.0) >= 2.16.0
BuildRequires: pkgconfig(libsearpc) >= 1.0
BuildRequires: pkgconfig(jansson) >= 2.2.1
BuildRequires: pkgconfig(libevent) >= 2.0
BuildRequires: pkgconfig(zlib) >= 1.2.0
BuildRequires: pkgconfig(libcurl) >= 7.17
BuildRequires: pkgconfig(libwebsockets) >= 4.0.20
BuildRequires: pkgconfig(libargon2)

Requires: lib%name = %EVR


%description
Seafile is a next-generation open source cloud storage system
with advanced support for file syncing, privacy protection and teamwork.

Collections of files are called libraries, and each library can be synced separately.
A library can be encrypted with a user chosen password.
This password is not stored on the server,
so even the server admin cannot view a file's contents.

Seafile allows users to create groups with file syncing,
wiki, and discussion to enable easy collaboration around documents within a team.

%package -n fuse-seafile
Summary: Seafile FUSE access
Group: Networking/File transfer
Requires: lib%name = %EVR

%description -n fuse-seafile
Seafile FUSE access.
Seafile is a next-generation open source cloud storage system
with advanced support for file syncing, privacy protection and teamwork.

%package cli
Summary: Seafile CLI client
Group: Networking/File transfer
Requires: lib%name = %EVR

%description cli
Seafile CLI client.

Seafile is a next-generation open source cloud storage system
with advanced support for file syncing, privacy protection and teamwork.

%package -n python3-module-seafile
Summary: Seafile client python3 module
Group: Networking/File transfer
Requires: lib%name = %EVR

%description -n python3-module-seafile
The python3 module with Seafile client.

%package -n lib%name
Summary: Seafile library files
Group: Networking/File transfer

%description -n lib%name
The lib%name package contains libraries for Seafile.

%package -n lib%name-devel
Summary: Development files for lib%name
Requires: lib%name = %version-%release
Group: Development/C

%description -n lib%name-devel
The lib%name-devel package contains libraries and header files for
developing applications that use lib%name.

%prep
%setup
#patch -p1
cp %SOURCE1 .
# remove buildroot from .pc file
%__subst 's/(DESTDIR)//' lib/libseafile.pc.in
#%__subst 's@#!/usr/bin/env python@#!%__python3@' app/seaf-cli

%build
%autoreconf
%configure --disable-static --enable-ws PYTHON=%__python3
# FIXME: breakes build
%make_build || %make

%install
%makeinstall_std

%files
%_bindir/seaf-daemon
%_man1dir/seaf-daemon*.1.*

%files cli
%_bindir/seaf-cli
%_man1dir/seaf-cli.1.*

%files -n lib%name
%_libdir/libseafile.so.*

%files -n python3-module-seafile
%python3_sitelibdir/%name/

%files -n lib%name-devel
%_includedir/seafile/
%_libdir/libseafile.so
%_pkgconfigdir/libseafile.pc

%changelog
