Name: sed
Version: 4.9.0.32.5420
Release: alt1
Epoch: 1

Summary: A GNU stream text editor
Group: Editors
License: GPLv3+
Url: https://www.gnu.org/software/sed/

%define srcname %name-%version-%release
# https://git.altlinux.org/people/glebfm/packages/sed.git refs/heads/sed-current
Source0: %srcname.tar
# https://git.altlinux.org/people/glebfm/packages/sed.git refs/heads/po-current
Source1: po-%version-%release.tar
Source2: subst.tar
# https://git.altlinux.org/people/glebfm/packages/sed.git sed-current..sed-alt
Patch: %srcname.patch

%def_enable selinux

BuildRequires: gnulib >= 0.1.5391.2a613

# due to CHECK_NORMAL_MENU_STRUCTURE option
BuildRequires: makeinfo >= 6.8

# for acl copying support.
BuildRequires: libacl-devel

%{?_enable_selinux:BuildRequires: libselinux-devel}

%description
The sed (Stream EDitor) editor is a stream or batch (non-interactive)
editor.  Sed takes text as input, performs an operation or set of
operations on the text and outputs the modified text.  The operations
that sed performs (substitutions, deletions, insertions, etc.) can be
specified in a script file or from the command line.

%prep
%setup -n %srcname -a1 -a2
%patch -p1

# Build scripts expect to find package version in this file.
echo -n %version-%release > .tarball-version
# Force configure.ac to define BUILD_MAN_PAGE.
mkdir .git

# Generate LINGUAS file.
ls po/*.po 2>/dev/null |
	sed 's|.*/||; s|\.po$||' > po/LINGUAS

# Compress docs for packaging.
xz doc/*.txt
xz -k NEWS

%build
%make_build -C subst CPPFLAGS="-D_GNU_SOURCE $(getconf LFS_CFLAGS)"
./subst/subst -p 's,@DOCDIR@,%_docdir/%name-%version,' \
	doc/sed.texi doc/sed.x

./bootstrap --force --skip-po --gnulib-srcdir=%_datadir/gnulib
%configure --bindir=/bin
%make_build -C po update-po
%make_build

%install
%makeinstall_std
%makeinstall_std -C subst

%find_lang %name

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%check
%make_build -k check

%files -f %name.lang
/bin/*
%_bindir/*
%_mandir/man?/*
%_infodir/*.info*
%doc BUGS NEWS.xz README doc/*.txt.xz

%changelog
