Name: shadow
Version: 4.17.4
Release: alt2
Epoch: 1

Summary: Utilities for managing shadow password files and user/group accounts
License: BSD-3-Clause and GPL-2.0-or-later
Group: System/Base
Url: https://github.com/shadow-maint/shadow

Source0: %url/%name-%version.tar
Source1: login.defs
Source2: useradd.default
Source3: user-group-mod.pamd
Source4: chfn-chsh.pamd
Source5: chpasswd-newusers.pamd
Source6: chage.control
Source7: chfn.control
Source8: chsh.control
Source9: gpasswd.control
Source10: newgrp.control
Source11: groupmems.control
Source12: groupmems.pamd
Source13: newuidmap.control
Source14: newgidmap.control

Patch: %name-%version-%release.patch

%def_disable bootstrap
%if_enabled bootstrap
%def_without selinux
%def_without audit
%def_without btrfs
%def_without pam
%def_disable man
%else
%def_with selinux
%def_with audit
%def_with btrfs
%def_with pam
%def_enable man
%endif

%define lsubid_sovers 5

# libbsd support for readpassphrase().
# Using in-source implementation instead.
%def_without libbsd

%set_verify_elf_method strict

BuildPreReq: mktemp >= 1:1.3.1, rpm-build >= 4.0.4-alt10
# for man pages generation
%if_enabled man
BuildRequires: xsltproc docbook-style-xsl docbook-dtds
%endif

%if_with selinux
BuildPreReq: libselinux-devel libsemanage-devel
%endif

%{?_with_audit:BuildRequires: libaudit-devel}

%if_with pam
BuildRequires: libpam-devel libtcb-devel pam_userpass-devel
%endif
BuildRequires: libcrypt-devel >= 4.0.1-alt1

%{?_with_libbsd:BuildRequires: libbsd-devel}

%description
This package includes the tools necessary for manipulating local user and
group databases. It supports both traditional and tcb shadow password files.

%package utils
Summary: Utilities for managing shadow password files and user/group accounts
Group: System/Base
Requires: %name-convert = %EVR
%if_with pam
Requires: tcb-utils >= 0.9.8
%endif
Obsoletes: adduser

%description utils
This package includes utilities for managing shadow password files and
user/group accounts:
+ useradd: creates a new user or updates default new user information;
+ userdel: deletes a user account and related files;
+ usermod: modifies a user account;
+ groupadd: creates a new group;
+ groupdel: deletes a group;
+ groupmod: modifies a group;
+ newusers: updates and creates new users in batch;
+ chpasswd: updates password file in batch.

%package check
Summary: Utilities for checking integrity of the password, group, shadow-password, or shadow-group files
Group: System/Base
Requires: %name-convert = %EVR

%description check
This package includes utilities for checking integrity of the password, group,
shadow-password, or shadow-group files:
+ pwck: verifies the integrity of the system password authentication information;
+ grpck: verifies the integrity of the system group authentication information.

%package convert
Summary: Utilities for convertion to and from shadow passwords and groups
Group: System/Base

%description convert
This package includes utilities for convertion to and from shadow passwords
and groups:
+ pwconv: creates shadow from passwd and an optionally existing shadow;
+ pwunconv: creates passwd from passwd and shadow and then removes shadow;
+ grpconv: creates gshadow from group and an optionally existing gshadow;
+ grpunconv: creates group from group and gshadow and then removes gshadow.

%package change
Summary: Utilities for changing user shell, finger and password information
Group: System/Base
Requires: %name-utils = %EVR

%description change
This package includes utilities for changing user shell, finger and password
information:
+ chage: changes the number of days between password changes and the date of
         the last password change;
+ chfn: changes user fullname, office number, office extension, and home phone
        number information for a user's account;
+ chsh: changes the user login shell.

%package edit
Summary: Utilities for editing the password, group, shadow-password, or shadow-group files
Group: System/Base
Requires: %name-utils = %EVR

%description edit
This package includes utilities for editing the password, group,
shadow-password, or shadow-group files:
+ vipw: edits the /etc/passwd and /etc/shadow files;
+ vigr: edits the /etc/group and /etc/gshadow files.

%package groups
Summary: Utilities for execute command as different group ID
Group: System/Base
Requires: %name-utils = %EVR

%description groups
This package includes utilities for execute command as different group ID:
+ gpasswd: is used to administer the /etc/group and etc/gshadow files;
+ newgrp: is used to change the current group ID during a login session;
+ sg: is used to execute command as different group ID.

%package submap
Summary: Utilities for creating uid and gid mappings in user namespaces
Group: System/Base
Requires: %name-utils = %EVR

%description submap
This package includes utilities for creating uid and gid mappings
in user namespaces:
* newuidmap: set the uid mapping of a user namespace;
* newgidmap: set the gid mapping of a user namespace.

%package -n libsubid%lsubid_sovers
Summary: Subordinate id handling library
Group: System/Libraries

%description -n libsubid%lsubid_sovers
The library provides an interface for querying, granding and ungranting
subordinate user and group ids.

%package -n libsubid-devel
Summary: Development files for the subordinate id handling library
Group: Development/C
Requires: libsubid%lsubid_sovers = %EVR

%description -n libsubid-devel
The library provides an interface for querying, granding and ungranting
subordinate user and group ids.
This package contains development files for libsubid.

%package log
Summary: Utilities for examining lastlog and faillog files
Group: System/Base
Requires: %name-utils = %EVR

%description log
This package includes utilities for examining lastlog and faillog files:
+ faillog: formats the contents of the system failure log file, and maintains
           failure counts and limits;
+ lastlog: formats the contents of the system last login file.

%package suite
Summary: The shadow suite
Group: System/Base
BuildArch: noarch
Requires: %name-change = %EVR
Requires: %name-check = %EVR
Requires: %name-convert = %EVR
Requires: %name-edit = %EVR
Requires: %name-groups = %EVR
Requires: %name-log = %EVR
Requires: %name-utils = %EVR
Requires: %name-submap = %EVR

%description suite
This virtual package unifies all shadow suite subpackages.

%prep
%setup
%patch -p1

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%ifnarch %e2k
%add_optflags -Werror -Wno-error=address -Wno-error=cpp
%endif
%add_optflags -DEXTRA_CHECK_HOME_DIR
%configure \
	--disable-static \
	--enable-lastlog \
	%{?_with_pam:--with-tcb} \
	%{?_with_pam:--with-libpam} \
	%{subst_with selinux} \
	%{subst_with audit} \
	%{subst_with btrfs} \
	%{subst_with libbsd} \
	--with-group-name-max-length=32 \
	--without-sha-crypt \
	--without-su \
	%{?_with_pam:--enable-account-tools-setuid} \
	%{subst_enable man}
%make_build

make -C po/ ru.gmo

%install
%makeinstall

install -pD -m640 %_sourcedir/login.defs %buildroot%_sysconfdir/login.defs
%if_without pam
sed -i %buildroot%_sysconfdir/login.defs \
	-r \
	-e 's/^(TCB_AUTH_GROUP.*)$/# \1/' \
	-e 's/^(USE_TCB.*)$/# \1/' \
	-e 's/^(TCB_SYMLINKS.*)$/# \1/' \
	%nil
%endif
install -pD -m600 %_sourcedir/useradd.default %buildroot%_sysconfdir/default/useradd

rm -rf %buildroot%_sysconfdir/pam.d
%if_with pam
mkdir -p %buildroot%_sysconfdir/pam.d
pushd %buildroot%_sysconfdir/pam.d
install -pm600 %_sourcedir/user-group-mod.pamd user-group-mod
ln -s user-group-mod groupadd
ln -s user-group-mod groupdel
ln -s user-group-mod groupmod
ln -s user-group-mod useradd
ln -s user-group-mod userdel
ln -s user-group-mod usermod
install -pm640 %_sourcedir/chfn-chsh.pamd chfn-chsh
ln -s chfn-chsh chfn
ln -s chfn-chsh chsh
install -pm600 %_sourcedir/chpasswd-newusers.pamd chpasswd-newusers
ln -s chpasswd-newusers chpasswd
ln -s chpasswd-newusers newusers
install -pm600 %_sourcedir/groupmems.pamd groupmems
popd
%endif

ln -s useradd %buildroot%_sbindir/adduser

install -pD -m755 %_sourcedir/chage.control %buildroot%_controldir/chage
install -pD -m755 %_sourcedir/chfn.control %buildroot%_controldir/chfn
install -pD -m755 %_sourcedir/chsh.control %buildroot%_controldir/chsh
install -pD -m755 %_sourcedir/gpasswd.control %buildroot%_controldir/gpasswd
install -pD -m755 %_sourcedir/newgrp.control %buildroot%_controldir/newgrp
install -pD -m755 %_sourcedir/groupmems.control %buildroot%_controldir/groupmems
install -pD -m755 %_sourcedir/newuidmap.control %buildroot%_controldir/newuidmap
install -pD -m755 %_sourcedir/newgidmap.control %buildroot%_controldir/newgidmap

touch %buildroot%_sysconfdir/subuid
touch %buildroot%_sysconfdir/subgid

mkdir -p %buildroot%_sysconfdir/shadow-maint/{user,group}{add,del}-{pre,post}.d

%find_lang %name
%define _unpackaged_files_terminate_build 1

%define save_login_defs_file  /tmp/shadow-utils-update-save-old-login.defs

%post convert
if [ $1 = 1 ]; then
	if [ ! -e /etc/gshadow ]; then
		%_sbindir/grpconv
	fi
	if [ ! -e /etc/shadow -a ! -e /etc/tcb ]; then
		%_sbindir/pwconv
	fi
fi

%pre utils
if [ $1 -eq 2 ]; then
	OLD_VERSION="$(rpm -q --qf '%%{EPOCH}:%%{VERSION}-%%{RELEASE}' %name-utils)"
	[ -z "$OLD_VERSION" ] || RES="$(rpmevrcmp "$OLD_VERSION" 1:4.13-alt3)"
	if [ -n "$RES" ] && [ $RES -lt 0 ]; then
		cp -a /etc/login.defs %save_login_defs_file
		# Ensure that old /etc/login.defs.rpmnew doesn't exist
		rm -f /etc/login.defs.rpmnew
	fi
fi

%triggerpostun utils -- %name-utils < 1:4.13-alt3
if [ -e %save_login_defs_file ] && [ ! -e /etc/login.defs.rpmnew ]; then
		mv /etc/login.defs /etc/login.defs.rpmnew && \
		  mv %save_login_defs_file /etc/login.defs && \
		  echo "warning: /etc/login.defs created as /etc/login.defs.rpmnew due to UID_MIN/GID_MIN change"
fi
rm -f %save_login_defs_file

%pre change
%pre_control chage chfn chsh

%post change
%post_control -s restricted chage chfn chsh

%pre groups
%pre_control gpasswd newgrp groupmems

%post groups
%post_control -s restricted gpasswd newgrp groupmems

%pre submap
%pre_control newuidmap newgidmap

%post submap
%post_control -s restricted newuidmap newgidmap

%files convert
%_sbindir/*conv
%if_enabled man
%_mandir/man?/*conv.*
%endif

%files utils -f %name.lang
%attr(600,root,root) %config(noreplace) %_sysconfdir/default/useradd
%attr(640,root,shadow) %config(noreplace) %_sysconfdir/login.defs
%dir %attr(770,root,root) %_sysconfdir/shadow-maint/
%dir %attr(770,root,root) %_sysconfdir/shadow-maint/user*.d/
%dir %attr(770,root,root) %_sysconfdir/shadow-maint/group*.d/
%if_with pam
%config(noreplace) %_sysconfdir/pam.d/user-group-mod
%_sysconfdir/pam.d/groupadd
%_sysconfdir/pam.d/groupdel
%_sysconfdir/pam.d/groupmod
%_sysconfdir/pam.d/useradd
%_sysconfdir/pam.d/userdel
%_sysconfdir/pam.d/usermod
%config(noreplace) %_sysconfdir/pam.d/chpasswd-newusers
%_sysconfdir/pam.d/chpasswd
%_sysconfdir/pam.d/newusers
%endif
%_sbindir/user*
%_sbindir/group*
%_sbindir/adduser
%_sbindir/newusers
%_sbindir/chpasswd
%if_enabled man
%_man5dir/login.defs.*
%_man5dir/shadow.*
%_man8dir/chpasswd.*
%_man8dir/group*.*
%_man8dir/newusers.*
%_man8dir/user*.*
%endif
%doc README
%exclude %_bindir/groupmems
%if_enabled man
%exclude %_man8dir/groupmems.*
%endif

%files check
%_sbindir/*ck
%if_enabled man
%_mandir/man?/*ck.*
%endif

%files change
%config %_controldir/chage
%config %_controldir/chfn
%config %_controldir/chsh
%if_with pam
%attr(640,root,shadow) %config(noreplace) %_sysconfdir/pam.d/chfn-chsh
%_sysconfdir/pam.d/chfn
%_sysconfdir/pam.d/chsh
%endif
%attr(700,root,root) %verify(not mode,group) %_bindir/chage
%attr(700,root,root) %verify(not mode) %_bindir/chfn
%attr(700,root,root) %verify(not mode) %_bindir/chsh
%if_enabled man
%_mandir/man?/chage.*
%_mandir/man?/chfn.*
%_mandir/man?/chsh.*
%endif

%files edit
%_sbindir/vi??
%if_enabled man
%_mandir/man?/vi??.*
%endif

%files groups
%if_with pam
%_sysconfdir/pam.d/groupmems
%endif
%config %_controldir/gpasswd
%config %_controldir/newgrp
%config %_controldir/groupmems
%attr(700,root,root) %verify(not mode,group) %_bindir/gpasswd
%attr(700,root,root) %verify(not mode,group) %_bindir/newgrp
%_bindir/sg
%attr(700,root,root) %verify(not mode,group) %_bindir/groupmems
%if_enabled man
%_mandir/man?/gpasswd.*
%_mandir/man?/newgrp.*
%_mandir/man?/sg.*
%_man8dir/groupmems.*
%endif

%files submap
%config(noreplace) %_sysconfdir/subuid
%config(noreplace) %_sysconfdir/subgid
%config %_controldir/newuidmap
%config %_controldir/newgidmap
%attr(700,root,root) %verify(not mode,group) %_bindir/newuidmap
%attr(700,root,root) %verify(not mode,group) %_bindir/newgidmap
%_bindir/getsubids
%if_enabled man
%_man1dir/newuidmap.*
%_man1dir/newgidmap.*
%_man1dir/getsubids.*
%_man5dir/subuid.*
%_man5dir/subgid.*
%endif

%files -n libsubid%lsubid_sovers
%_libdir/libsubid.so.%lsubid_sovers
%_libdir/libsubid.so.%lsubid_sovers.*

%files -n libsubid-devel
%_libdir/libsubid.so
%_includedir/shadow/

%files log
%_bindir/*log
%if_enabled man
%_mandir/man?/*log.*
%endif

%files suite

%exclude %_bindir/expiry
%exclude %_sbindir/chgpasswd
%exclude %_sbindir/logoutd
%exclude %_sbindir/nologin
%if_enabled man
%exclude %_man1dir/expiry.1.*
%exclude %_man3dir/getspnam.3.*
%exclude %_man3dir/shadow.3.*
%exclude %_man5dir/gshadow.5.*
%exclude %_man5dir/passwd.5.*
%exclude %_man8dir/chgpasswd.8.*
%exclude %_man8dir/logoutd.8.*
%exclude %_man8dir/nologin.8.*
%endif
%if_without pam
%exclude %_sysconfdir/limits
%exclude %_sysconfdir/login.access
%endif

%changelog
