%def_disable snapshot
%define ver_major 48
%define beta %nil
%define xdg_name org.gnome.Snapshot

%def_disable bootstrap
%def_enable check

Name: snapshot
Version: %ver_major.0.1
Release: alt1%beta

Summary: GNOME Camera
License: GPL-3.0-or-later
Group: Video
Url: https:/apps.gnome.org/Snapshot

Vcs: https://gitlab.gnome.org/GNOME/snapshot.git

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version%beta.tar
%endif
Source1: %name-%version-cargo.tar

%define glib_ver 2.76
%define pango_ver 1.51
%define gtk_ver 4.16
%define adwaita_ver 1.7
%define gst_ver 1.20
%define seccomp_ver 2.5.0

Provides: gnome-camera = %EVR
Requires: gst-plugins-base1.0 >= %gst_ver
Requires: gst-plugins-bad1.0 >= %gst_ver
Requires: gst-plugins-libcamera1.0
Requires: gst-plugin-gtk4
Requires: glycin-loaders

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson rust-cargo
BuildRequires: pkgconfig(gio-2.0) >= %glib_ver
BuildRequires: pkgconfig(pango) >= %pango_ver
BuildRequires: pkgconfig(gtk4) >= %gtk_ver
BuildRequires: pkgconfig(libadwaita-1) >= %adwaita_ver
BuildRequires: pkgconfig(gstreamer-video-1.0) >= %gst_ver
BuildRequires: pkgconfig(gstreamer-plugins-bad-1.0) >= %gst_ver
# for Glycin
BuildRequires: pkgconfig(libseccomp) >= %seccomp_ver pkgconfig(lcms2)
%{?_enable_check:BuildRequires: /usr/bin/appstreamcli desktop-file-utils clippy}

%description
A simple application to take pictures and videos from camera on your
computer, tablet, or phone.

%prep
%setup -n %name-%version%beta %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
[ ! -d .cargo ] && mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version-cargo.tar .cargo/ vendor/}

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README*


%changelog
