Name:    solaar
Version: 1.1.13
Release: alt2

Summary: Device manager for Logitech Unifying Receiver
License: GPL-2.0-or-later
Group:   System/Configuration/Hardware
URL:     https://pwr-solaar.github.io/Solaar/

BuildArch: noarch

Packager: Andrey Cherepanov <cas@altlinux.org>

Vcs: https://github.com/pwr-Solaar/Solaar.git
Source: %name-%version.tar
Patch2: 0002-Install-alternative-udev-rules-for-wayland-compatibi.patch
Patch3: 0003-Install-autostart-desktop-file.patch
Patch4: remove-udev-check.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-gir
BuildRequires:  python3-module-pyudev

%add_python3_req_skip gi.repository.GObject gi.repository.Gdk

# require typelib(AyatanaAppIndicator3) instead typelib(AppIndicator3)
%add_typelib_req_skiplist typelib(AppIndicator3)

%py3_requires evdev
Requires: udev-rules-logitech-unify

%description
Solaar is a device manager for Logitech's Unifying Receiver
peripherals. It is able to pair/unpair devices to the receiver, and
for most devices read battery status.

It comes in two flavors, command-line and GUI. Both are able to list
the devices paired to a Unifying Receiver, show detailed info for each
device, and also pair/unpair supported devices with the receiver.

%package doc
Summary: Documentation for Solaar
Group: Documentation
Requires: %name = %EVR

%description doc
This package provides documentation for Solaar, a device manager for
Logitech's Unifying Receiver peripherals.

%package -n udev-rules-logitech-unify
Summary:  Udev rules for Logitech receivers
Group:    System/Configuration/Hardware
Provides: %name-udev = %EVR

%description -n udev-rules-logitech-unify
This package contains udev rules which grant users permission to access various
connected Logitech wireless receivers.  This includes Unifying receivers,
various types of Nano receivers and some other types which can be used by
Solaar.

%prep
%setup
%patch2 -p1
%patch3 -p1
%patch4 -p1

sed -i 's|lib/udev/rules.d|%_udev_rulesdir|g' setup.py

%build
tools/po-compile.sh
%python3_build

%install
%python3_install
%find_lang %name

%files -f %name.lang
%doc COPYRIGHT share/README
%config(noreplace) %_sysconfdir/xdg/autostart/solaar.desktop
%_bindir/solaar
%python3_sitelibdir/*
%_desktopdir/solaar.desktop
%_iconsdir/hicolor/scalable/apps/*.svg
%_iconsdir/hicolor/32x32/apps/*.png
%_datadir/metainfo/*.metainfo.xml

%files doc
%doc docs

%files -n udev-rules-logitech-unify
%_udevrulesdir/*.rules

%changelog
