%define _unpackaged_files_terminate_build 1
%define _runtimedir /run
%define _localstatedir /var
#Use GTK+ instead of Xlib
%def_with gtk4

Name: spice-vdagent
Version: 0.23.0
Release: alt3
Epoch: 1
Summary: Agent for Spice guests
Group: Networking/Remote access
License: GPLv3+
Url: http://spice-space.org/

# VCS-git: https://gitlab.freedesktop.org/spice/linux/vd_agent.git
Source: %name-%version.tar
Patch: %name-%version.patch

BuildRequires(pre): rpm-macros-systemd
BuildRequires: pkgconfig(gio-unix-2.0) >= 2.50
%if_with gtk4
BuildRequires: pkgconfig(gtk4) >= 3.98
%else
BuildRequires: pkgconfig(gtk+-3.0) >= 3.22
%endif
BuildRequires: pkgconfig(xfixes) pkgconfig(xrandr) >= 1.3 pkgconfig(xinerama) pkgconfig(x11)
BuildRequires: pkgconfig(spice-protocol) >= 0.14.3
BuildRequires: pkgconfig(alsa) >= 1.0.22
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(libdrm)
BuildRequires: pkgconfig(pciaccess) >= 0.10
BuildRequires: desktop-file-utils
BuildRequires: pkgconfig(systemd) pkgconfig(libsystemd) >= 209
BuildRequires: pkgconfig(udev)
BuildRequires: desktop-file-utils

%description
Spice agent for Linux guests offering the following features:

Features:
* Client mouse mode (no need to grab mouse by client, no mouse lag)
  this is handled by the daemon by feeding mouse events into the kernel
  via uinput. This will only work if the active X-session is running a
  spice-vdagent process so that its resolution can be determined.
* Automatic adjustment of the X-session resolution to the client resolution
* Support of copy and paste (text and images) between the active X-session
  and the client

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
    %{subst_with gtk4} \
    --with-session-info=systemd \
    --with-init-script=systemd

%make_build

%install
%makeinstall_std tmpfilesdir=%_tmpfilesdir udevrulesdir=%_udevrulesdir systemdunitdir=%_unitdir userunitdir=%_user_unitdir

# fix autostart in KDE Plasma
cp -ar %buildroot/%_sysconfdir/xdg/autostart/spice-vdagent{,-kde}.desktop
desktop-file-install --mode=0644 --dir %buildroot/%_sysconfdir/xdg/autostart \
	--add-not-show-in="KDE" \
	%buildroot/%_sysconfdir/xdg/autostart/spice-vdagent.desktop
desktop-file-install --mode=0644 --dir %buildroot/%_sysconfdir/xdg/autostart \
	--add-only-show-in="KDE" \
	--remove-key="X-GNOME-Autostart-Phase" \
	--set-key="Exec" --set-value="/usr/bin/spice-vdagent -x" \
	%buildroot/%_sysconfdir/xdg/autostart/spice-vdagent-kde.desktop

%files
%doc COPYING CHANGELOG.md README.md
%_udevrulesdir/*.rules
%_tmpfilesdir/spice-vdagentd.conf
%_unitdir/*
%_userunitdir/*
%_bindir/spice-vdagent
%_sbindir/spice-vdagentd
%_sysconfdir/xdg/autostart/spice-vdagent*.desktop
%_man1dir/*

%changelog
