%define sover 0
%define git %nil
%define build_type RelWithDebInfo
%define _cmake %cmake -DCMAKE_BUILD_TYPE=%build_type
%define optflags_lto %nil

Name: spirv-tools
Version: 2025.4
Release: alt0.1
Epoch: 1

Summary: API and commands for processing SPIR-V modules
Group: Development/C++
License: Apache-2.0

Url: https://www.khronos.org/registry/spir-v/
Packager: L.A. Kostis <lakostis@altlinux.org>

Source: https://github.com/KhronosGroup/SPIRV-Tools/archive/v%version/SPIRV-Tools-%version.tar
Patch0: %name-soname-alt.patch
Patch1: %name-alt-cmake-path.patch

BuildRequires(pre): cmake ninja-build
BuildRequires: gcc-c++
BuildRequires: python3-devel
# due sdk requirements
BuildRequires: spirv-headers >= 2:1.5.5-alt20

%description
The package includes an assembler, binary module parser,
disassembler, and validator for SPIR-V.

%package -n lib%name%sover
Summary: SPIR-V tool component library
Group: System/Libraries

%description -n lib%name%sover
The SPIR-V Tool library contains all of the implementation details
driving the SPIR-V assembler, binary module parser, disassembler and
validator, and is used in the standalone tools whilst also enabling
integration into other code bases directly.

%package -n lib%name-devel
Summary: Development headers for the SPIR-V tool library
Group: Development/C++
Requires: lib%name%sover = %EVR

%description -n lib%name-devel
The SPIR-V Tool library contains all of the implementation details
driving the SPIR-V assembler, binary module parser, disassembler and
validator, and is used in the standalone tools whilst also enabling
integration into other code bases directly.

%prep
%setup -n SPIRV-Tools-%version
%patch0 -p2
%patch1 -p2

# will check protobuf support later
# for fuzzler
%build
%_cmake \
  -GNinja \
  -DSPIRV_BUILD_COMPRESSION=OFF \
  -DSPIRV_BUILD_FUZZER=OFF \
  -DSPIRV_TOOLS_BUILD_STATIC=OFF \
  -DSPIRV-Headers_SOURCE_DIR=%_prefix \
%ifarch %e2k
  -DSPIRV_WERROR=OFF \
%endif
  -DCMAKE_VERBOSE_MAKEFILE=ON \
  -DBUILD_SHARED_LIBS=ON

ninja \
  -vvv \
  -j %__nprocs \
  -C %_cmake__builddir

%install
%cmake_install

%files
%doc CHANGES LICENSE README.md
%_bindir/spirv-*

%files -n lib%name%sover
%_libdir/libSPIRV-Tools.so.*
%_libdir/libSPIRV-Tools-*.so.*

%files -n lib%name-devel
%_libdir/libSPIRV-Tools.so
%_libdir/libSPIRV-Tools-*.so
%_pkgconfigdir/SPIRV-Tools.pc
%_pkgconfigdir/SPIRV-Tools-shared.pc
%_includedir/%name
%_datadir/cmake/SPIRV-Tools*

%changelog
