Name: sqlmap
Version: 1.5.3
Release: alt1.1

Summary: Automatic SQL injection and database takeover tool

Group: Monitoring
License: GPLv2
Url: http://sqlmap.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/sqlmapproject/sqlmap/archive/%version.tar.gz
Source: %name-%version.tar

# Remove dependency on distutils
Patch: 69900a6c6efac5c8b43fcee5d8d03dc2afb063b5.patch

BuildArch: noarch

BuildPreReq: rpm-build-intro

BuildRequires: perl-Net-RawIP perl-NetPacket
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-paste

%add_python3_lib_path %_datadir/%name
%add_python3_req_skip thirdparty.six.moves
%add_findprov_skiplist %_datadir/%name/extra/*
%add_findprov_skiplist %_datadir/%name/lib/*
%add_findprov_skiplist %_datadir/%name/plugins/*
%add_findprov_skiplist %_datadir/%name/tamper/*
%add_findprov_skiplist %_datadir/%name/thirdparty/*

%description
sqlmap is an open source penetration testing tool that automates the process of
detecting and exploiting SQL injection flaws and taking over of database
servers. It comes with a powerful detection engine, many niche features for the
ultimate penetration tester and a broad range of switches lasting from database
fingerprinting, over data fetching from the database, to accessing the
underlying file system and executing commands on the operating system via
out-of-band connections.

%prep
%setup
%patch -p1
%remove_repo_info
find . -type f -and -name '*.py' -exec sed -i "s|#!%_bindir/env python2\?\$|#!%__python3|" {} \;
%__subst "s|#!/usr/bin/env python$|#!%__python3|" sqlmap.py sqlmapapi.py

# remove obsoleted bundled modules
%__subst "s|thirdparty.chardet|chardet|" lib/{core,request}/*.py
rm -rfv thirdparty/{xdot,chardet}

%install
install -d -m 755 %buildroot%_datadir/%name
install -m 755 sqlmap.py %buildroot%_datadir/%name
install -m 755 sqlmapapi.py %buildroot%_datadir/%name
cp -pr data %buildroot%_datadir/%name/
cp -pr extra %buildroot%_datadir/%name/
rm -rfv %buildroot%_datadir/%name/extra/runcmd/
rm -rfv %buildroot%_datadir/%name/extra/shutils/
cp -pr lib %buildroot%_datadir/%name/
cp -pr plugins %buildroot%_datadir/%name/
cp -pr tamper %buildroot%_datadir/%name/
cp -pr thirdparty %buildroot%_datadir/%name/

install -d -m 755 %buildroot%_bindir
for app in sqlmap sqlmapapi; do
cat > %buildroot%_bindir/$app <<EOF
#!/bin/sh
cd %_datadir/%name
exec ./$app.py \$@
EOF
chmod +x %buildroot%_bindir/$app
done

install -d -m 755 %buildroot%_sysconfdir
install -m 644 sqlmap.conf %buildroot%_sysconfdir
pushd %buildroot%_datadir/%name
ln -s ../../..%_sysconfdir/sqlmap.conf .
popd

%files
%doc doc/*
%_datadir/%name
%_bindir/%name
%_bindir/%{name}api
%config(noreplace) %_sysconfdir/%name.conf

%changelog
