# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: stalld
Version: 1.19.3
Release: alt1
Summary: Daemon that finds starving tasks and gives them a temporary boost

License: GPL-2.0-only
Group: System/Kernel and hardware
Url: https://gitlab.com/rt-linux-tools/stalld
# Presentation: https://linuxplumbersconf.org/event/7/contributions/769/
# Video: https://youtu.be/JHE_3iU9nTs?t=10608
# Slides: https://linuxplumbersconf.org/event/7/contributions/769/attachments/572/1010/OSnoise-RT.pdf

Source: %name-%version.tar

%description
The stalld program monitors the set of system threads, looking for threads
that are ready-to-run but have not been given processor time for some threshold
period. When a starving thread is found, it is given a temporary boost using
the SCHED_DEADLINE policy. The default is to allow 10 microseconds of runtime
for 1 second of clock time.

%prep
%setup
%ifarch %e2k
# What is the reason for using hardcoded syscall numbers?
sed -i "1i #include <sys/syscall.h>" src/stalld.h
%endif
sed -i s/-lpthread/-pthread/ Makefile
sed -i /README.md/d Makefile
sed -i '1s!/usr/bin/bash!/bin/bash!' scripts/throttlectl.sh

%build
%add_optflags %(getconf LFS_CFLAGS)
# USE_BPF=0: https://gitlab.com/rt-linux-tools/stalld/-/issues/17
%make_build CFLAGS='%optflags -DVERSION=\"%version\"' USE_BPF=0

%install
%makeinstall_std UNITDIR=%_unitdir USE_BPF=0
rm %buildroot/usr/share/licenses/stalld/gpl-2.0.txt

%check
./stalld --version | grep -Fx '%version'
# Not much to test.
# https://gitlab.com/rt-linux-tools/stalld/-/issues/23

%post
%post_service stalld.service

%preun
%preun_service stalld.service

%files
%doc README.md gpl-2.0.txt
%config(noreplace) %_sysconfdir/sysconfig/stalld
%_bindir/stalld
%_bindir/throttlectl
%_unitdir/stalld.service
%_man8dir/stalld.8*

%changelog
