Name: strace
Version: 6.17
Release: alt1

Summary: Tracks and displays system calls associated with a running process
# The test suite is GPLv2+, all the rest is LGPLv2.1+.
License: LGPL-2.1-or-later and GPL-2.0-or-later
Group: Development/Debuggers
Url: https://strace.io

# http://git.altlinux.org/gears/s/strace.git
Source: %name-%version-%release.tar

# due to use of deprecated -k option
Conflicts: rpm-utils <= 0:0.9.11-alt1

# for -k option
BuildRequires: libdw-devel binutils-devel

# for --secontext option
BuildRequires: libselinux-devel

# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc /dev/pts /dev/kvm %{?_enable_vmrun:rpm-build-vm-run iproute2}}}

# The default is --enable-mpers=yes, but
# some architectures may need --enable-mpers=check instead.
%define mpers_check %nil
%define architectures_need_mpers_check aarch64
%ifarch %architectures_need_mpers_check
%define mpers_check --enable-mpers=check
%endif

%description
The strace program intercepts and records the system calls called and
the signals received by a running process.  strace can print a record of
each system call, its arguments and its return value.  strace is useful
for diagnosing problems and debugging, as well as for instructional
purposes.

%prep
%setup -n %name-%version-%release
echo -n %version-%release > .tarball-version
echo -n 2025 > .year
date +%%Y-%%m-%%d > doc/.strace.1.in.date
date +%%Y-%%m-%%d > doc/.strace-log-merge.1.in.date

%build
echo 'BEGIN OF BUILD ENVIRONMENT INFORMATION'
uname -a |head -1
libc="$(ldd /bin/sh |sed -n 's|^[^/]*\(/[^ ]*/libc\.so[^ ]*\).*|\1|p' |head -1)"
$libc |head -1
file -L /bin/sh
gcc --version |head -1
ld --version |head -1
kver="$(printf '%%s\n%%s\n' '#include <linux/version.h>' 'LINUX_VERSION_CODE' | gcc -E -P -)"
printf 'kernel-headers %%s.%%s.%%s\n' $(($kver/65536)) $(($kver/256%%256)) $(($kver%%256))
echo 'END OF BUILD ENVIRONMENT INFORMATION'

./bootstrap -sv
mkdir build
cd build
%define _configure_script ../configure
CFLAGS_FOR_BUILD="$RPM_OPT_FLAGS"; export CFLAGS_FOR_BUILD
%configure %mpers_check --enable-bundled=yes #--enable-maintainer-mode
%make_build

%install
%makeinstall_std -C build
%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%check
%make_build -C build check-prerequisites

cat > make-check <<'__EOF__'
#!/bin/sh -eux
export SLEEP_A_BIT='sleep 0.5' VERBOSE=1
echo "RUNNING $* TEST SUITE"
%make_build -k check -C build VERBOSE=1

echo "BEGIN OF $* TEST SUITE INFORMATION"
tail -n 99999 -- build/tests*/test-suite*.log build/tests*/ksysent.gen.log
find build/tests* -type f -name '*.log' -print0 |
	xargs -r0 grep -H '^KERNEL BUG:' -- ||:
echo "END OF $* TEST SUITE INFORMATION"
__EOF__
chmod +x make-check

%buildroot%_bindir/strace -V

%if_enabled vmrun
img="$TMPDIR/make-check.img"
timeout 999 vm-run --kvm=cond --sbin --ext4 --create-rootfs="$img" \
	--append='oops=panic panic_on_warn=1' \
	"sysctl kernel.userns_restrict=0 && ./make-check KVM"
rm "$img"
%endif
./make-check LOCAL

%files
%_bindir/strace
%_bindir/strace-log-merge
%_mandir/man?/*
%doc COPYING CREDITS NEWS README doc/README-linux-ptrace

%changelog
