# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%ifnarch ppc64le
%set_verify_elf_method strict,lint=relaxed
%endif

%def_with gpu

Name: stress-ng
Version: 0.17.08
Release: alt1
Summary: Stress test a computer system in various selectable ways
Group: System/Kernel and hardware
License: GPL-2.0-only
Url: https://github.com/ColinIanKing/stress-ng

Source: %name-%version.tar

BuildRequires(pre): rpm-macros-make
BuildRequires: banner
BuildRequires: libacl-devel
BuildRequires: libaio-devel
BuildRequires: libattr-devel
BuildRequires: libbsd-devel
BuildRequires: libcap-devel
BuildRequires: libgcrypt-devel
BuildRequires: libgmp-devel
BuildRequires: libjpeg-devel
BuildRequires: libjudy-devel
BuildRequires: libkeyutils-devel
BuildRequires: libkmod-devel
BuildRequires: liblksctp-devel
BuildRequires: libmpfr-devel
BuildRequires: libseccomp-devel
BuildRequires: libxxhash-devel
BuildRequires: zlib-devel
%if_with gpu
BuildRequires: libEGL-devel
BuildRequires: libgbm-devel
BuildRequires: libglvnd-devel
%endif

%description
stress-ng will stress test a computer system in various selectable
ways. It was designed to exercise various physical subsystems
of a computer as well as the various operating system kernel
interfaces. Stress-ng features:

  * 320+ stress tests
  * 80+ CPU specific stress tests that exercise floating point, integer,
    bit manipulation and control flow
  * 20+ virtual memory stress tests
  * 40+ file system stress tests
  * 30+ memory/CPU cache stress tests
  * portable: builds on Linux (Debian, Devuan, RHEL, Fedora, Centos, Slackware
    OpenSUSE, Ubuntu, etc..), Solaris, FreeBSD, NetBSD, OpenBSD, DragonFlyBSD,
    Minix, Android, MacOS X, Serenity OS, GNU/Hurd, Haiku, Windows Subsystem
    for Linux and SunOs/Dilos/Solaris.
    with gcc, clang, icc, tcc and pcc.
  * tested on alpha, armel, armhf, arm64, hppa, i386, m68k, mips32, mips64,
    power32, ppc64el, risc-v, sh4, s390x, sparc64, x86-64

stress-ng was originally intended to make a machine work hard and trip
hardware issues such as thermal overruns as well as operating system
bugs that only occur when a system is being thrashed hard. Use stress-ng
with caution as some of the tests can make a system run hot on poorly
designed hardware and also can cause excessive system thrashing which
may be difficult to stop.

stress-ng can also measure test throughput rates; this can be useful to
observe performance changes across different operating system releases
or types of hardware. However, it has never been intended to be used as
a precise benchmark test suite, so do NOT use it in this manner.

%prep
%setup
%ifarch %e2k
# lcc 1.23 can't do string attribute form (1.24.03 will; mcst#4061)
sed -ri 's,"-O([0123])",\1,' stress-ng.h
%endif

%build
%ifarch ppc64le
# Disable LTO as is does not build on ppc64:
#   https://github.com/ColinIanKing/stress-ng/issues/273
#   {standard input}: Assembler messages:
#   {standard input}:20240: Error: unrecognized opcode: `darn'
%define optflags_lto %nil
%endif
%make_build_ext --no-print-directory --output-sync=none VERBOSE=1

%install
%makeinstall_std

install -pD kernel-coverage.sh %buildroot%_datadir/stress-ng/kernel-coverage.sh
install -pDm644 syscalls.txt   %buildroot%_datadir/stress-ng/syscalls.txt
install -pD debian/tests/fast-test-all %buildroot%_datadir/stress-ng/fast-test-all
install -pD debian/tests/lite-test     %buildroot%_datadir/stress-ng/lite-test

%check
# Cache test for a long time hanging ALT beekeeper for a unknown reason.
sed -i '/STRESSORS/s/ cache / /g' debian/tests/lite-test

banner lite-test
time timeout 300 make lite-test V=1
banner done

%files
%define _customdocdir %_docdir/%name
%doc COPYING README.md mascot/stress-ng.svg debian/changelog
%_bindir/stress-ng
%_datadir/bash-completion/completions/stress-ng
%_datadir/stress-ng
%_mandir/man1/stress-ng.1*

%changelog
