%define _unpackaged_files_terminate_build 1
%define _libexecdir /usr/libexec
#set capability dropping library.
#Currently supported values are "libcap" and "native".
%define capabilities libcap
%def_enable gcrypt
%def_enable eap_sim_pcsc
%def_disable load_tests
%def_enable nm
%def_enable tpm
%def_enable sqlite
%def_disable static
%def_disable uci
%def_disable unit_tests
# this one requires that libhydra and libcharon be
# underlinked on purpose, contact mike@ for email
# explanation by Tobias Brunner (11 May 2010)
%def_disable integrity_test

%define beta %nil

Name: strongswan
Version: 5.9.14
Release: alt4

Summary: strongSwan IPsec implementation
License: GPLv2+
Group: System/Servers

# git://git.strongswan.org/strongswan.git
Url: http://www.strongswan.org
Source0: %name-%version%beta.tar.gz
Source1: %name.init
Source100: strongswan.watch
Patch10: strongswan-5.6.0-uintptr_t.patch
# https://github.com/strongswan/strongswan/issues/1198
Patch11: strongswan-5.9.7-error-no-format.patch
Patch12: strongswan-disable-bypass-lan.patch
Patch13: strongswan-dont-load-kernel-libipsec-plugin-by-default.patch

Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Mon Jul 02 2012
# optimized out: pkg-config
BuildRequires: flex gperf libcap-devel libcurl-devel libgmp-devel libldap-devel libpam-devel libssl-devel
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(json-c)
BuildRequires: pkgconfig(libip4tc)
%{?_enable_tpm:BuildRequires: pkgconfig(tss2-sys) pkgconfig(tss2-esys)}
%{?_enable_eap_sim_pcsc:BuildRequires: pkgconfig(libpcsclite)}
%{?_enable_gcrypt:BuildRequires: libgcrypt-devel libgpg-error-devel}
%{?_enable_sqlite:BuildRequires: libsqlite3-devel}
%{?_enable_nm:BuildRequires: pkgconfig(gthread-2.0) pkgconfig(libnm)}
BuildRequires: pkgconfig(systemd)

Provides: libstrongswan = %version-%release
Obsoletes: libstrongswan < 4.3

%define pkgdocdir %_docdir/%name-%version

%description
strongSwan is a free implementation of IPsec & IKE for Linux. IPsec is the
Internet Protocol Security and uses strong cryptography to provide both
authentication and encryption services. These services allow you to build
secure tunnels through untrusted networks. Everything passing through the
untrusted net is encrypted by the ipsec gateway machine and decrypted by the
gateway at the other end of the tunnel. The resulting tunnel is a virtual
private network or VPN.

This package contains the service and userland tools for setting up strongSwan
on a freeswan enabled kernel.

%package testing
Summary: %name testing
Group: Documentation
Requires: %name = %version
BuildArch: noarch

%description testing
This package contains testing scripts and configuration snippets
of strongSwan documentation

%package charon-nm
Summary: NetworkManager plugin for Strongswan
Group: System/Servers

%description charon-nm
NetworkManager plugin integrates a subset of Strongswan capabilities
to NetworkManager.

%package sqlite
Summary: SQLite support for strongSwan
Group: System/Servers
Requires: %name = %EVR

%description sqlite
The sqlite plugin adds an SQLite database backend to strongSwan.
 
%package tnc-imcvs
Summary: Trusted network connect (TNC)'s IMC/IMV functionality
Group: System/Servers
Requires: %name = %EVR
Requires: %name-sqlite = %EVR

%description tnc-imcvs
This package provides Trusted Network Connect's (TNC) architecture support.
It includes support for TNC client and server (IF-TNCCS), IMC and IMV message
exchange (IF-M), interface between IMC/IMV and TNC client/server (IF-IMC
and IF-IMV). It also includes PTS based IMC/IMV for TPM based remote
attestation, SWID IMC/IMV, and OS IMC/IMV. It's IMC/IMV dynamic libraries
modules can be used by any third party TNC Client/Server implementation
possessing a standard IF-IMC/IMV interface. In addition, it implements
PT-TLS to support TNC over TLS.

%prep
%setup -n %name-%version%beta
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1

%build
%autoreconf
%configure \
	%{subst_enable static} \
	--with-ipsec-script=%name \
	--sysconfdir=%_sysconfdir/%name \
	--with-ipsecdir=%_libexecdir/%name \
	--bindir=%_libexecdir/%name \
	--with-ipseclibdir=%_libdir/%name \
	--with-piddir=/run \
	--with-nm-ca-dir=%_sysconfdir/%name/ipsec.d/cacerts/ \
	--enable-acert \
	--enable-addrblock \
	--enable-af-alg \
	--enable-agent \
	--enable-bypass-lan \
	--enable-ccm \
	--enable-certexpire \
	--enable-chapoly \
	--enable-connmark \
	--enable-cmd \
	--enable-ctr \
	--enable-curl \
	--enable-dhcp \
	--enable-duplicheck \
	--enable-eap-aka \
	--enable-eap-aka-3gpp \
	--enable-eap-aka-3gpp2 \
	--enable-eap-dynamic \
	--enable-eap-gtc \
	--enable-eap-identity \
	--enable-eap-md5 \
	--enable-eap-mschapv2 \
	--enable-eap-peap \
	--enable-eap-radius \
	--enable-eap-sim \
	--enable-eap-sim-file \
	%{?_enable_eap_sim_pcsc: --enable-eap-sim-pcsc} \
	--enable-eap-tls \
	--enable-eap-tnc \
	--enable-eap-ttls \
	--enable-ext-auth \
	--enable-error-notify \
	--enable-farp \
	--enable-forecast \
	--enable-gcm \
	%{subst_enable gcrypt} \
	--enable-ha \
	--enable-ipseckey \
	--enable-ldap \
	--enable-led \
	--enable-lookip \
	--enable-md4 \
	--enable-newhope \
	--enable-ntru \
	--enable-openssl \
	--enable-pkcs11 \
	--enable-smp \
	--enable-sql \
	--enable-sqlite \
	--enable-stroke \
	--enable-swanctl \
	--enable-unity \
	%{subst_enable tpm} \
	--enable-tss-tss2 \
	%{subst_enable uci} \
	%{subst_enable nm} \
	--enable-systemd \
	--with-systemdsystemunitdir=%_unitdir \
	--with-capabilities=%capabilities \
	%{?_enable_unit_tests: --enable-unit-tests} \
	%{?_enable_load_tests: --enable-load-tests} \
	--enable-xauth-eap \
	--enable-xauth-pam \
	--enable-xauth-noauth \
	--enable-tnc-ifmap \
	--enable-tnc-pdp \
	--enable-tnc-imc \
	--enable-tnc-imv \
	--enable-tnccs-20 \
	--enable-tnccs-11 \
	--enable-tnccs-dynamic \
	--enable-imc-test \
	--enable-imv-test \
	--enable-imc-scanner \
	--enable-imv-scanner  \
	--enable-imc-attestation \
	--enable-imv-attestation \
	--enable-imv-os \
	--enable-imc-os \
	--enable-imc-swima \
	--enable-imv-swima \
	--enable-imc-hcd \
	--enable-imv-hcd \
	--enable-vici \
	%{?_enable_kernel_netlink: --enable-kernel-netlink} \
	%{?_enable_kernel_pfkey: --enable-kernel-pfkey} \
	%{?_enable_integrity_test: --enable-integrity-test} \
	%ifarch x86_64 %{ix86}
	--enable-aesni \
	--enable-rdrand \
	%endif
	--enable-kernel-libipsec \
	--disable-fast \
	CPPFLAGS="-DSTARTER_ALLOW_NON_ROOT" \
	%nil

#

# ensure manual page is regenerated with local configuration
rm -f src/ipsec/_ipsec.8

%make_build

%install
%makeinstall_std

install -pDm755 %SOURCE1 %buildroot%_initdir/%name
rm -f testing/do-tests* testing/Makefile.*

# It is the file in the package whose name matches the format emacs or vim uses 
# for backup and autosave files. It may have been installed by  accident.
find $RPM_BUILD_ROOT \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete
# failsafe cleanup if the file is declared as %%doc
find . \( -name '.*.swp' -o -name '#*#' -o -name '*~' \) -print -delete

# prefix man pages
for i in %buildroot%_mandir/*/*; do
    if echo "$i" | grep -vq '/strongswan[^\/]*$'; then
        mv "$i" "`echo "$i" | sed -re 's|/([^/]+)$|/strongswan_\1|'`"
    fi
done
find %buildroot -type f -name '*.la' -delete
# delete unwanted library files - no consumers, so no -devel package
rm -f %buildroot%_libdir/%name/*.so


%post
if sd_booted; then
    %post_service_posttrans_restart strongswan.service
    %post_service_posttrans_restart strongswan-starter.service
else
    %post_service_posttrans_restart strongswan
fi

%preun
if sd_booted; then
    %preun_service strongswan.service
    %preun_service strongswan-starter.service
else
    %preun_service strongswan
fi

# since 5.9.14 we have 'strongswan' chkconfig entry instead of 'ipsec' one
%triggerun -- %name < 5.9.14
if [ $2 -gt 0 ]; then
# This is strongswan upgrade.
        chkconfig ipsec >/dev/null 2>&1 && ipsec_enabled=1 || ipsec_enabled=0
        chkconfig --del ipsec
        chkconfig --add strongswan
        if [ $ipsec_enabled -eq 1 ] ; then
            chkconfig strongswan on
        fi
fi

%files
%doc ChangeLog NEWS README TODO
%attr(755,root,root) %dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/*
%_initdir/strongswan
%_unitdir/strongswan.service
%_unitdir/strongswan-starter.service
%_datadir/%name
%_libexecdir/%name
%_libdir/%name
%_sbindir/charon-cmd
%_sbindir/charon-systemd
%_sbindir/%name
%_sbindir/swanctl
%_man1dir/*
%_man5dir/*
%_man8dir/*

%if_enabled nm
%exclude %_libexecdir/%name/charon-nm
%endif
%if_enabled sqlite
%exclude %_libdir/%name/plugins/libstrongswan-sqlite.so
%endif
%exclude %_libdir/%name/imcvs
%exclude %_libdir/strongswan/libimcv.so.*
%exclude %_libdir/strongswan/libtnccs.so.*
%exclude %_libdir/%name/plugins/libstrongswan-*tnc*.so
%exclude %_libexecdir/strongswan/attest
%exclude %_libexecdir/strongswan/pt-tls-client
%exclude %_datadir/strongswan/swidtag

%files testing
%doc testing

%if_enabled nm
%files charon-nm
%_datadir/dbus-1/system.d/nm-strongswan-service.conf
%_libexecdir/%name/charon-nm
%endif

%if_enabled sqlite
%files sqlite
%_libdir/%name/plugins/libstrongswan-sqlite.so
%endif

%files tnc-imcvs
%_sbindir/sw-collector
%_sbindir/sec-updater
%_libdir/strongswan/imcvs
%_libdir/strongswan/libimcv.so.*
%_libdir/strongswan/libtnccs.so.*
%_libdir/strongswan/plugins/libstrongswan-*tnc*.so
%_libexecdir/strongswan/attest
%_libexecdir/strongswan/pt-tls-client
%_datadir/strongswan/swidtag

# TODO:
# - libstrongswan{,-devel} subpackages
# - review configurables (see also fedora-proposed spec)

%changelog
