%define _unpackaged_files_terminate_build 1

Name: summain
Version: 0.26.0
Release: alt2

Summary: File manifest generator
License: GPLv3+
Group: File tools
Url: https://doc.liw.fi/summain/

Source0: %name-%version.tar
Source1: vendor.tar
Source2: cargo_config.toml
Patch: %name-%version-alt.patch

BuildRequires: rust-cargo
BuildRequires: /proc

%description
Produce a manifest of specified files. The manifest lists the files, and for
each file its important metadata, and if it's a regular file, the checksum of
the contents. The order in the output is deterministic: if the program is run
twice for the same file, and files haven't changed, the output is identical.

This is meant for testing that a backup has been restored correctly.

%prep
%setup -a1
%autopatch -p1

# point to vendored sources
export CARGO_HOME=${PWD}/.cargo
mkdir "$CARGO_HOME"
cp "%SOURCE2" "$CARGO_HOME/config.toml"

%build
export CARGO_HOME=${PWD}/.cargo
cargo build --offline --release

%install
export CARGO_HOME=${PWD}/.cargo
cargo install --offline --force --root %buildroot/%_usr --path ./ --no-track

%check
# requires Subplot: https://subplot.liw.fi/
# see 'check' file for details

%files
%doc *.md
%_bindir/summain

%changelog
