%define rname taglib
%define _K6link %_K6lib

%define sover 2
%define libtag libtag%sover
%define libtag_c libtag_c%sover

Name: taglib
Version: 2.1.1
Release: alt1

Group: System/Libraries
Summary: TagLib, is well, a library for reading and editing audio meta data
License: (LGPL-2.1-only OR MPL-1.1) AND BSD-2-Clause AND LGPL-2.1-only
Url: http://taglib.github.io/

Provides: %rname = %version-%release

Source0: %rname-%version.tar

# SuSE
Patch2: taglib-1.8-ds-rusxmms-r2.patch

BuildRequires(pre): rpm-build-kf6
BuildRequires: gcc-c++ zlib-devel libutfcpp-devel
#BuildRequires: librcc-devel
BuildRequires: doxygen graphviz cmake

%description
TagLib, is well, a library for reading and editing audio meta data,
commonly know as tags.
Some goals of TagLib:
	A clean, high level, C++ API to handling audio meta data.
	Support for at least ID3v1, ID3v2 and Ogg Vorbis comments.
	A generic, simple API for the most common tagging related functions.
	Binary compatibility between minor releases using the standard KDE/Qt
	techniques for C++ binary compatibility.
	Make the tagging framework extensible by library users; i.e. it will be
	possible for libarary users to implement additional ID3v2 frames,
	without modifying the TagLib source.
Because TagLib desires to be toolkit agnostic, in hope of being widely
adopted and the most flexible in licensing TagLib provides many of its
own toolkit classes; in fact the only external dependancy that TagLib has,
it a semi-sane STL implementation.

%package devel
Group: Development/C
Summary: Headers and static lib for taglib development
#Provides: libtag-devel = %version-%release
Conflicts: libtag-devel
%description devel
Install this package if you want do compile applications using the libtag
library.

%package -n %libtag
Summary: Library for reading and editing audio meta data
Group: System/Libraries
%description -n %libtag
TagLib is a library for reading and editing the meta-data of several
popular audio formats. Currently it supports both ID3v1 and ID3v2 for MP3
files, Ogg Vorbis comments and ID3 tags and Vorbis comments in FLAC, MPC,
Speex, WavPack, TrueAudio files, as well as APE Tags

%package -n %libtag_c
Summary: Library for reading and editing audio meta data
Group: System/Libraries
%description -n %libtag_c
TagLib is a library for reading and editing the meta-data of several
popular audio formats. Currently it supports both ID3v1 and ID3v2 for MP3
files, Ogg Vorbis comments and ID3 tags and Vorbis comments in FLAC, MPC,
Speex, WavPack, TrueAudio files, as well as APE Tags

%prep
%setup -n %rname-%version
#%patch2 -p1

%build
%K6cmake \
    -DINCLUDE_INSTALL_DIR=%_includedir \
    -DWITH_ASF:BOOL=ON \
    -DWITH_MP4:BOOL=ON \
    -DBUILD_EXAMPLES:BOOL=OFF \
    -DBUILD_TESTS:BOOL=OFF \
    -DBUILD_SHARED_LIBS:BOOL=ON \
    #
%K6make
%K6make docs

%install
%K6install

#install alternative
sed -i -E 's|^Requires:[[:space:]]+%rname$|Requires: %rname-2|' %buildroot/%_libdir/pkgconfig/%{rname}_c.pc
mv %buildroot/%_libdir/pkgconfig/%rname{,-2}.pc
mv %buildroot/%_libdir/pkgconfig/%{rname}_c{,-2}.pc
install -d %buildroot/%_sysconfdir/alternatives/packages.d/
cat > %buildroot/%_sysconfdir/alternatives/packages.d/%name-devel <<__EOF__
%_libdir/pkgconfig/%rname.pc %_libdir/pkgconfig/%rname-2.pc %version
%_libdir/pkgconfig/%rname.pc %_libdir/pkgconfig/%{rname}_c-2.pc %version
__EOF__

%files -n %libtag
%doc AUTHORS CHANGELOG.md
%_libdir/libtag.so.%sover
%_libdir/libtag.so.*

%files -n %libtag_c
%doc AUTHORS CHANGELOG.md
%_libdir/libtag_c.so.%sover
%_libdir/libtag_c.so.*

%files devel
%doc BUILD*/doc/html AUTHORS CHANGELOG.md README.md
%config %_sysconfdir/alternatives/packages.d/%name-devel
%_bindir/taglib-config
%_libdir/libtag.so
%_libdir/libtag_c.so
%_libdir/pkgconfig/taglib*.pc
%dir %_includedir/taglib/
%_includedir/taglib/*.h
%_includedir/taglib/*.tcc
%_libdir/cmake/taglib/

%changelog
