%global optflags_lto %optflags_lto -ffat-lto-objects

%def_with test
%define major 8.6
%define tcloo 1.1.0
%define itcl 4.2.3
%define tdbc 1.1.5
%define thread 2.8.8
%define zlib 2.0.1

Name: tcl
Version: 8.6.13
Release: alt1

Summary: The Tool Command Language (TCL)
License: TCL
Group: Development/Tcl
Url: http://www.tcl.tk/

# repacked ftp://ftp.tcl.tk/pub/tcl/tcl8_6/tcl%version-src.tar.gz
Source: %name%version-src.tar
Source1: tcl.m4
Patch1: 0001-ALT-private-headers.patch
Patch2: 0002-ALT-soname.patch
Patch3: 0003-ALT-norpath.patch
Patch4: 0004-ALT-nostdinc.patch
Patch5: 0005-ALT-libpath.patch
Patch6: 0006-Revert-generic-tclObj.c-remove-superfluous-include-o.patch
Patch7: 0007-ALT-TCL_LIBS-for-shared-linkage.patch
Patch8: 0008-ALT-tclsh.1-fix-shebang-example.patch
Patch9: 0009-ALT-pkgs-TEA.patch
Patch10: 0010-ALT-itcl-TCL_INCLUDES.patch
Patch11: 0011-ALT-pkgs-test.patch
Patch12: 0012-ALT-pkgs-LDFLAGS.patch
Patch13: 0013-ALT-pkgs-soname.patch
Patch14: 0014-ALT-pkgs-tclstub-linkage.patch

BuildRequires(pre): rpm-build-tcl >= 0.4-alt1
%{?_with_test:BuildConflicts: tcl-vfs}
%{?_with_test:BuildRequires: libmariadb-devel}
%{?_with_test:BuildRequires: postgresql-devel}
%{?_with_test:BuildRequires: libiodbc-devel}
%{?_with_test:BuildRequires: tcl-sqlite3}
BuildRequires: zlib-devel

Conflicts: tcl-incrtcl < 4 tcl-incrtk < 4
Conflicts: tcl-readline < 2.1.1-alt8

%package pkgs
Summary: The Tool Command Language (TCL) - packages
Group: Development/Tcl
Provides: tcl-tdbc = %tdbc
Provides: tcl-tdbcmysql = %tdbc
Provides: tcl-tdbcodbc = %tdbc
Provides: tcl-tdbcpostgres = %tdbc
# tcl-thread is bundled in tcl sources
Provides: tcl-thread = %thread
Conflicts: tcl-thread <= 2.8.2-alt1
Obsoletes: tcl-thread

%package pkg-incrtcl4
Summary: The Tool Command Language (TCL) - Itcl package
Group: Development/Tcl
# tcl-incrtcl4 is bundled in tcl sources
Provides: tcl-incrtcl4 = %itcl
Provides: tcl-incrtcl = %itcl
Conflicts: tcl-incrtcl4 <= 4.1.1-alt1
Obsoletes: tcl-incrtcl4

%package -n lib%name
Summary: The Tool Command Language (TCL) - shared library
Group: System/Libraries
Provides: %_tcllibdir
Provides: %_tcldatadir
Provides: tcl(TclOO) = %tcloo
Provides: tcl(TclOO)-%(echo %tcloo |cut -c 1) = %tcloo
Provides: tcl(zlib) = %zlib
Provides: tcl(zlib)-%(echo %zlib |cut -c 1) = %zlib
Obsoletes: tcl-zlib <= %zlib

%package devel
Summary: Header files and C programming manual for TCL
Group: Development/C
Requires: %name
Requires: rpm-build-tcl >= 0.5-alt1
Conflicts: tcl-incrtcl4-devel <= 4.1.1-alt1
Conflicts: tcl-thread-devel <= 2.8.2-alt1

%package pkgs-devel
Summary: Meta package for TCL pkgs devel
Group: Development/C
BuildArch: noarch
Requires: %name-devel
Requires: %name-pkgs
Requires: %name-pkg-incrtcl4
Obsoletes: tcl-incrtcl4-devel tcl-thread-devel
Provides: tcl-incrtcl4-devel = %itcl
Provides: tcl-tdbc-devel = %tdbc
Provides: tcl-thread-devel = %thread

%description
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

%description pkgs
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

This package includes packages shipped with Tcl distribution.

%description pkg-incrtcl4
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

This package includes intrtcl package shipped with Tcl distribution.

%description -n lib%name
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

This package includes shared Tcl library only.

%description devel
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

This package includes header files and C programming manuals for Tcl.

%description pkgs-devel
The Tcl (Tool Command Language) provides a powerful platform for
creating integration applications that tie together diverse
applications, protocols, devices, and frameworks.  When paired with
the Tk toolkit, Tcl provides the fastest and most powerful way to
create GUI applications that run on PCs, Unix, and the Macintosh.  Tcl
can also be used for a variety of web-related tasks and for creating
powerful command languages for applications.

This package is metapackage for TCL pkgs devel.

%prep
%setup -q -n %name%version
%autopatch -p2
cp -p %SOURCE1 tcl.m4
# remove unneeded stuff
rm -r compat/zlib macosx win
# sqlite extension is built from sqlite3 package
rm -r pkgs/sqlite*

%build
pushd unix
%autoreconf
%configure \
	--disable-rpath \
	--enable-symbols \
	--enable-threads \
	--without-tzdata \
	#
make all
popd

%install
%define docdir %_defaultdocdir/%name-%version
%define __tclsh %buildroot%_bindir/.tclsh

%make_install INSTALL_ROOT=%buildroot install install-private-headers -C unix
mkdir -p %buildroot%_tcllibdir %buildroot%_tcldatadir %buildroot%docdir
install -p -m0644 -D tcl.m4 %buildroot%_datadir/aclocal/tea.m4
ln -sf tclsh%major %buildroot%_bindir/tclsh
ln -sf lib%name%major.so %buildroot%_libdir/lib%name.so
ln -s ../unix/tclUnixPort.h %buildroot%_includedir/tcl/generic/tclUnixPort.h
cat <<EOF > %__tclsh
#!/bin/sh
LD_LIBRARY_PATH=%buildroot%_libdir; export LD_LIBRARY_PATH
TCL_LIBRARY=%buildroot%_tcldatadir/%name%major; export TCL_LIBRARY
exec %buildroot%_bindir/tclsh "\$@"
EOF
chmod +x %__tclsh
xz ChangeLog changes
install -pm0644 README.md license.terms changes.xz ChangeLog.xz %buildroot%docdir

# collect man pages
find pkgs/*/doc -name '*.n' -type f -fprintf pkgsmans '%%%%_mandir/mann/%%f*\n'
find pkgs/itcl*/doc -name '*.n' -type f -fprintf itclmans '%%%%_mandir/mann/%%f*\n'
sed 's/^/%%exclude\ /' pkgsmans > exclude_pkgsmans
join -v1 pkgsmans itclmans >pkgsmans.tmp
mv pkgsmans{.tmp,}

%check
# skip clock.test due lack of /etc/localtime in the build environment (ALT#35848)
rm -f tests/clock.test
pushd unix
make test |tee check.log
sed -n '/^all.tcl/{/Failed\s\+[^0]/q1}'
! grep -qF "Test files exiting with errors" check.log
popd

# zlib guard
cat <<EOF > zlib_guard.tcl
if {![catch {package present zlib} version]} {
	if {[string equal \$version "%zlib"]} {
		exit 0
	}
}

exit 1
EOF
%__tclsh zlib_guard.tcl

# tclOO guard
cat <<EOF > TclOO_guard.tcl
if {![catch {package present TclOO} version]} {
	if {[string equal \$version "%tcloo"]} {
		exit 0
	}
}

exit 1
EOF
%__tclsh TclOO_guard.tcl

%files -f exclude_pkgsmans
%dir %docdir
%docdir/README.md
%docdir/license.terms
%docdir/changes.*

%_bindir/tclsh*

%_tcldatadir/tcl8
%_tcldatadir/%name%major
%exclude %_tcldatadir/%name%major/%{name}AppInit.c
%exclude %_tcldatadir/%name%major/auto.tcl
%exclude %_tcldatadir/%name%major/init.tcl
%exclude %_tcldatadir/%name%major/package.tcl

%_man1dir/*
%_mandir/mann/*

%files pkgs -f pkgsmans
%_tcllibdir/tdbc%tdbc
%_tcllibdir/tdbcmysql%tdbc
%_tcllibdir/tdbcodbc%tdbc
%_tcllibdir/tdbcpostgres%tdbc
%_tcllibdir/thread%thread

%dir %_libdir/tcl8
%dir %_libdir/tcl8/%major
%dir %_libdir/tcl8/%major/tdbc
%_libdir/tcl8/%major/tdbc/sqlite3-%tdbc.tm

%exclude %_tcllibdir/tdbc%tdbc/libtdbcstub%tdbc.a

%files pkg-incrtcl4 -f itclmans
%_tcllibdir/itcl%itcl

%exclude %_tcllibdir/itcl%itcl/libitclstub%itcl.a

%files -n lib%name
%dir %_tcllibdir
%dir %_tcldatadir
%dir %_tcldatadir/%name%major
%_libdir/lib%name%major.so

%_tcldatadir/%name%major/auto.tcl
%_tcldatadir/%name%major/init.tcl
%_tcldatadir/%name%major/package.tcl

%files devel
%docdir/ChangeLog.*
%_includedir/*
%_pkgconfigdir/%name.pc
%_libdir/lib%name.so
%_libdir/lib%{name}stub%{major}.a
%_tcllibdir/itcl%itcl/libitclstub%itcl.a
%_tcllibdir/tdbc%tdbc/libtdbcstub%tdbc.a
%_libdir/%{name}Config.sh
%_libdir/%{name}ooConfig.sh
%_libdir/itclConfig.sh
%_libdir/tdbcConfig.sh
%_tcldatadir/%name%major/%{name}AppInit.c
%_datadir/aclocal/*.m4
%_man3dir/*

%dir %_tcllibdir/itcl%itcl
%dir %_tcllibdir/tdbc%tdbc

%files pkgs-devel

%changelog
