%def_disable snapshot
%define ver_major 2.1

%def_enable check

Name: terminator
Version: %ver_major.4
Release: alt1

Summary: Store and run multiple GNOME terminals in one window
Group: Terminals
License: GPL-2.0
Url: https://github.com/gnome-terminator/terminator

%if_disabled snapshot
Source: %url/archive/v%version/%name-%version.tar.gz
%else
Vcs: https://github.com/gnome-terminator/terminator.git
Source: %name-%version.tar
%endif

# fc
Patch: %name-1.91-fc-fix-desktop-file.patch

BuildArch: noarch

%add_python3_req_skip gi.repository.GLib

Requires: typelib(Gtk) = 3.0
Requires: typelib(Vte) = 2.91

BuildRequires(pre): rpm-build-python3 rpm-build-gir

BuildRequires: python3-module-wheel python3-module-setuptools
BuildRequires: intltool
%{?_enable_check:BuildRequires: /proc xvfb-run python3(pytest)
BuildRequires: python3(gi) python3(cairo) python3(configobj)
BuildRequires: python3(dbus) python3(psutil)
BuildRequires: typelib(Vte) = 2.91 typelib(Notify) typelib(Keybinder)}

%description
Multiple GNOME terminals in one window. This is a project to produce an
efficient way of filling a large area of screen space with terminals.
This is done by splitting the window into a resizeable grid of terminals.
As such, you can  produce a very flexible arrangements of terminals for
different tasks.

%prep
%setup
sed -i '/#! \?\/usr.*/d' terminatorlib/*.py
%patch

%build
%pyproject_build

%install
%pyproject_install
%find_lang %name

%check
export PYTHONPATH=%buildroot%python3_sitelibdir_noarch
xvfb-run py.test-3

%files -f %name.lang
%_bindir/%name
%_bindir/remotinator
%python3_sitelibdir_noarch/terminatorlib/
%python3_sitelibdir_noarch/%{pyproject_distinfo %name}
%_datadir/%name/
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/*/*.*
%_iconsdir/HighContrast/*/*/*.*
%_datadir/pixmaps/%name.png
%_datadir/metainfo/%name.metainfo.xml
%_man1dir/%name.*
%_man5dir/%{name}_config.*
%doc README* CHANGELOG*

%changelog
