%define ver 171125
%define EVR %{?epoch:%epoch:}%version-%release
%define sover 5
%define libtidy lib%name%sover

Name: tidy
Version: 5.6.0
Release: alt2.20%ver
Epoch: 20171125

Summary: HTML Tidy helps keep webpages clean
License: W3C
Group: Text tools

Url: http://www.html-tidy.org/
# repacked https://github.com/htacg/tidy-html5/archive/refs/tags/%version.tar.gz
Source0: %name.tgz
Packager: Michael Shigorin <mike@altlinux.org>

Summary(ru_RU.UTF-8): HTML Tidy помогает чистить web-страницы
Summary(uk_UA.UTF-8): HTML Tidy допомагає чистити web-сторінки

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: cmake
BuildRequires: xsltproc

Requires: %libtidy = %EVR

%description
When editing HTML it's easy to make mistakes. Wouldn't it be nice
if there was a simple way to fix these mistakes automatically and
tidy up sloppy editing into nicely layed out markup? Well now
there is! Dave Raggett's HTML TIDY is a free utility for doing
just that. It also works great on the atrociously hard to read
markup generated by specialized HTML editors and conversion
tools, and can help you identify where you need to pay further
attention on making your pages more accessible to people with
disabilities.

Tidy is able to fix up a wide range of problems and to bring to
your attention things that you need to work on yourself. Each
item found is listed with the line number and column so that you
can see where the problem lies in your markup. Tidy won't
generate a cleaned up version when there are problems that it
can't be sure of how to handle. These are logged as "errors"
rather than "warnings".

%description -l ru_RU.UTF-8
При редактировании HTML легко ошибиться.  Правда, было бы
неплохо, чтобы существовал простой путь автоматического
исправления таких ошибок и подчистки несуразного текста до
аккуратной разметки?  Теперь он есть!  Свободная утилита HTML
TIDY от Dave Ragett занимается именно этим.  Также способствует
обработке особенно нечитабельной разметки из-под
специализированных редакторов HTML и утилит конвертирования;
может помочь найти места, требующие внимания для повышения
доступности информации.

Tidy может справиться со многими проблемами и привлечь внимание
к тому, что лучше исправить вручную.  Каждая обнаруженная проблема
выдается с номером строки и колонкой, чтоб было проще ее найти.
Tidy не будет создавать обработанную версию, пока остаются
проблемы, исправить которые автоматически не выходит --
они отмечаются как "ошибки", а не "замечания".

%description -l uk_UA.UTF-8
При редагуванні HTML легко помилитися.  Дійсно, було б непогано,
якщо б існував простий шлях автоматичного виправлення таких
помилок та підчистки незграбного тексту до чемної розмітки?
Тепер він є!  Вільна утиліта HTML TIDY від Dave Ragett займається
саме цим.  Також сприяє обробці особливо нездатної до читання
розмітки з-під спеціалізованих редакторів HTML та утиліт
конвертування; може допомогти знайти місця, що потребують на
додаткову увагу для підвищення досяжності інформації.

Tidy може впоратися із багатьма проблемами та пригорнути увагу
до того, що краще виправити вручну.  Кожна знайдена помилка
видається із номером рядку та колонкою, щоб її було легше знайти.
Tidy не буде створювати оброблену версію, доки залишаються
проблеми, виправити які автоматично не виходить -- вони
відмічаються як "помилки" замість "попереджень".

%package -n %libtidy
Summary: Shared libraries for %name
Group: System/Libraries

%description -n %libtidy
Shared libraries for %name

%package -n lib%name-devel
Summary: Header files and libraries for %name development
Group: Development/C
Requires: %libtidy = %EVR

%description -n lib%name-devel
Header files and libraries for %name development

%if_enabled static
%package -n lib%name-devel-static
Summary: Static libraries for %name development
Group: Development/C
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
Static libraries for %name development
%endif

%prep
%setup -n %name
# strip UTF8 BOM (lcc chokes otherwise)
find -name '*.c' -o -name '*.h' | xargs sed -ri 's,^\xEF\xBB\xBF,,'

%build
%cmake \
  -DCMAKE_BUILD_TYPE:STRING=Release
  #

%cmake_build

%install
%cmake_install

# compat symlinks for header renames
# until apps are adapted for the new api
ln -s tidybuffio.h %buildroot%_includedir/buffio.h
ln -s tidyplatform.h %buildroot%_includedir/platform.h

%if_enabled static
%else
rm %buildroot%_libdir/*.a
%endif

%files
%doc README
%_bindir/*
%_man1dir/*

%files -n %libtidy
%_libdir/lib%name.so.%sover
%_libdir/lib%name.so.%sover.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/%name.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
