%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

Name: tint2
Version: 17.0.2
Release: alt2
Summary: Simple panel/taskbar made for modern x window managers

Group: Graphical desktop/Other
License: GPLv2
Url: https://gitlab.com/o9000/tint2

Source: %name-%version.tar
Patch0: tint2-undefined-reference-to-symbol.patch

BuildRequires(pre): rpm-macros-cmake

# Automatically added by buildreq on Sat Jul 03 2010
BuildRequires: cmake gcc-c++ imlib2-devel libXcomposite-devel libXdamage-devel libXinerama-devel libXrandr-devel libpango-devel
BuildRequires: libstartup-notification-devel
BuildRequires: libcairo-devel libpixman-devel libexpat-devel
BuildRequires: libXdmcp-devel libXxf86vm-devel libharfbuzz-devel
BuildRequires: libgtk+3-devel librsvg-devel

%description
tint2 is a simple panel/taskbar made for modern x window managers.
It was specifically made for openbox3  but should also work with
other window managers (GNOME, KDE, etc...).

%prep
%setup -q %name-%version
%patch0 -p2

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%cmake \
	-DENABLE_TINT2CONF=ON \
	-DENABLE_EXAMPLES=ON

%cmake_build

%install
%cmakeinstall_std

%find_lang tint2conf

%files -f tint2conf.lang
%doc %_datadir/doc/*
%_datadir/applications/*.desktop
%_datadir/%name
%_iconsdir/hicolor/scalable/apps/*.svg
%dir %_sysconfdir/xdg/%name/
%config(noreplace) %_sysconfdir/xdg/%name/tint2rc
%_bindir/*
%_man1dir/*
%_datadir/mime/packages/tint2conf.xml

%changelog
