Name: tzdata
Version: 2024a
Release: alt1

Summary: Timezone data
# tzdata itself is Public Domain, but tzupdate is GPLv2+,
# so it is OK to release the whole as GPLv2+.
License: GPLv2+
Group: System/Base
Url: http://www.iana.org/time-zones
BuildArch: noarch

%define srcname %name-%version-%release
%define srcdir %_usrsrc/%name

# git://git.altlinux.org/gears/t/tzdata.git
Source: %srcname.tar

Provides: zoneinfo /usr/sbin/tzupdate
Obsoletes: zoneinfo
Conflicts: glibc-timezones <= 6:2.5.1-alt7

BuildRequires: hardlink /usr/sbin/zic

%description
This package contains data files with rules for various timezones around
the world.

%package source
Summary: Timezone data source
Group: Development/Other
Requires: %name = %version-%release

%description source
This package contains timezone data source for use by tz compilers.

%prep
%setup -n %srcname
mkdir .rearguard
cp -a -t .rearguard -- *
xz -9k NEWS

%build
%define make_args CC='%__cc' CFLAGS='%optflags' MANTXTS= VERSION=%version
make %make_args

%define rearguard tzdata%version-rearguard.tar.gz
make -C .rearguard %rearguard %make_args

%install
case "$(rpm --eval %%_priority_distbranch)" in
	'' | %%* | [a-z][0-9] | [a-z][0-9][^0-9]* ) ZFLAGS='-b fat' ;;
	*) ZFLAGS= ;;
esac
%make_install install_default DESTDIR=%buildroot \
	MANTXTS= ZONETABLES=zone1970.tab \
	VERSION=%version ZFLAGS="$ZFLAGS"
mv %buildroot%_datadir/zoneinfo{-leaps,/right}
rm %buildroot%_datadir/zoneinfo-posix
mkdir %buildroot%_datadir/zoneinfo/posix
cp -al %buildroot%_datadir/zoneinfo/[A-Z]* %buildroot%_datadir/zoneinfo/posix/

install -pDm755 tzupdate %buildroot%_sbindir/tzupdate

mkdir -p %buildroot%srcdir
tar -xf .rearguard/%rearguard -C %buildroot%srcdir
echo '%name%version' > %buildroot%srcdir/VERSION

# Hardlink identical files together.
%define __spec_install_custom_post hardlink -vc %buildroot

%check
for f in *.html; do touch check_"$f"; done
make -k check %make_args

# test basic glibc compatibility
cat > expected <<'EOF'
Mon Aug 17 12:00:00 UTC 2015
Mon Aug 17 15:00:00 IDT 2015
Mon Aug 17 14:00:00 CEST 2015
Mon Aug 17 05:00:00 PDT 2015
EOF
{
	d='%buildroot%_datadir/zoneinfo'
	t='@1439812800'

	TZ=UTC date -d "$t"
	TZ="$d/Asia/Jerusalem" date -d "$t"
	TZ="$d/Europe/Amsterdam" date -d "$t"
	TZ="$d/America/Los_Angeles" date -d "$t"
} > output
diff -u expected output || {
	: "$d is not compatible with glibc"
	exit 1
}

%post -p %_sbindir/tzupdate

%files
%_sbindir/tzupdate
%_datadir/zoneinfo
%doc NEWS.xz README *.html

%files source
%srcdir/

%changelog
