Name: u-boot-qemu
Version: 2025.10
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware

ExclusiveArch: aarch64 %ix86 x86_64 riscv32 riscv64

Source: %name-%version-%release.tar

BuildRequires: dtc >= 1.4 flex libgnutls-devel libssl-devel libuuid-devel
BuildRequires: python3(setuptools)
BuildRequires: python3(libfdt)

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package contains U-Boot image for QEMU virt machine.

%ifarch aarch64
%define qemu qemu_arm64
%endif
%ifarch %ix86
%define qemu qemu-x86
%endif
%ifarch x86_64
%define qemu qemu-x86_64
%endif
%ifarch riscv32
%define qemu qemu-riscv32
%endif
%ifarch riscv64
%define qemu qemu-riscv64_smode
%endif

%prep
%setup

%build
export DTC=%_bindir/dtc
%make_build %{qemu}_defconfig all

%install
%ifarch %ix86 x86_64
install -pm0644 -D u-boot.rom %buildroot%_datadir/u-boot/%qemu/u-boot.rom
%else
install -pm0644 -D u-boot.bin %buildroot%_datadir/u-boot/%qemu/u-boot.bin
%endif

%files
%doc README
%_datadir/u-boot/*

%changelog
