Name: u-boot-rockchip
Version: 2025.10
Release: alt1

Summary: Das U-Boot
License: GPLv2+
Group: System/Kernel and hardware
Url: https://docs.u-boot.org/en/latest/

%ifndef crossbuild
ExclusiveArch: aarch64
%endif

Source: %name-%version-%release.tar

BuildRequires: aarch64-none-elf-gcc
BuildRequires: atf-rockchip >= 2.12 rk35-firmware >= 20241023
BuildRequires: bc ccache dtc >= 1.4 flex libgnutls-devel libssl-devel libuuid-devel
BuildRequires: python3(libfdt)
BuildRequires: python3(setuptools)
BuildRequires: python3(elftools.elf.elffile)

%description
boot loader for embedded boards based on PowerPC, ARM, MIPS and several
other processors, which can be installed in a boot ROM and used to
initialize and test the hardware or to download and run application code.
This package supports various Rockchip based boards.

%prep
%setup
rm configs/generic-rk33*_defconfig
sed -i '/^CONFIG_FS_EXFAT/d' configs/*
# ALT#55304
sed '/^CONFIG_DEFAULT_FDT_FILE/ s,powkiddy-x55,powkiddy-x35s,' \
	< configs/powkiddy-x55-rk3566_defconfig \
	> configs/powkiddy-x35s-rk3566_defconfig

%build
export PYTHON=python3
export DTC=%_bindir/dtc
export RKBIN=%_datadir/rkbin/bin/rk35
export CROSS_COMPILE=aarch64-none-elf-

buildit()
{
  O=build/${board}
  BL31=%_datadir/atf/$1/bl31.elf \
  %make_build HOSTCC='ccache gcc' O=${O} ${board}_defconfig all
  mkdir -p out/${board}
  zstd ${O}/u-boot-rockchip.bin -o out/${board}/u-boot-rockchip.bin.zst
  rm -rf ${O}
}

export ROCKCHIP_TPL=$RKBIN/rk3588_ddr_lp4_2112MHz_lp5_2400MHz_v1.18.bin
soc=RK3588
boards=$(fgrep -lr CONFIG_ROCKCHIP_${soc} configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do buildit ${soc,,[A-Z]}; done

export ROCKCHIP_TPL=$RKBIN/rk3568_ddr_1560MHz_v1.23.bin
soc=RK3568
boards=$(fgrep -lr CONFIG_ROCKCHIP_${soc} configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do buildit ${soc,,[A-Z]}; done

unset ROCKCHIP_TPL

for soc in PX30 RK3328 RK3399; do
boards=$(fgrep -lr CONFIG_ROCKCHIP_${soc} configs |sed 's,^configs/\(.\+\)_defconfig,\1,')
for board in $boards; do buildit ${soc,,[A-Z]}; done
done

%install
mkdir -p %buildroot%_datadir/u-boot
cp -a out/* %buildroot%_datadir/u-boot

%files
%doc README doc/README.rockchip doc/board/rockchip
%_datadir/u-boot/*

%changelog
