Name: ubridge
Version: 0.9.19
Release: alt1

Summary: Bridge for UDP tunnels, Ethernet, TAP and VMnet interfaces
License: GPL-3.0-or-later
Group: Networking/Other
Url: https://github.com/GNS3/ubridge
Vcs: https://github.com/GNS3/ubridge.git

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: libpcap-devel
BuildRequires: libiniparser-devel
BuildRequires: libnl-devel

Requires(pre): libcap-utils

%description
uBridge is a simple application to create user-land bridges between various
technologies. Currently bridging between UDP tunnels, Ethernet and TAP
interfaces is supported. Packet capture is also supported.

%prep
%setup
%autopatch -p1

%build
%make_build SYSTEM_INIPARSER=1 CFLAGS="-DLINUX_RAW $RPM_OPT_FLAGS -lnl-3"

%install
mkdir -p %buildroot%_bindir
install -p -m4755 %name %buildroot%_bindir

%post
setcap cap_net_admin,cap_net_raw=ep %_bindir/%name

%files
%doc LICENSE README.md
%attr(0755,root,root) %_bindir/%name

%changelog
