# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name unshield
%define major	0
%define libname	lib%{name}%{major}
%define devname	lib%{name}-devel

Name:		unshield
Version:	1.4.3
Release:	alt1_4
Summary:	Install InstallShield applications on a Pocket PC
Group:		File tools
License:	MIT
URL:		http://synce.sourceforge.net/
Source0:	https://github.com/twogood/unshield/archive/%{version}/unshield-%{version}.tar.gz
# Originally from openSUSE:
Patch0100:	libconvert_utf_static.patch
BuildRequires:	pkgconfig(zlib)
BuildRequires:	pkgconfig(openssl)
BuildRequires:	ccmake cmake ctest
Source44: import.info

%description
To install a Pocket PC application remotely, an installable
Microsoft Cabinet File is copied to the /Windows/AppMgr/Install
directory on the PDA and then the wceload.exe is executed to
perform the actual install. That is a very simple procedure.

Unfortunately, many applications for Pocket PC are distributed as
InstallShield installers for Microsoft Windows, and not as
individual Microsoft Cabinet Files. That is very impractical for
users of other operating systems, such as Linux or FreeBSD.

%package -n %{libname}
Summary:	Shared libraries for %{name}
Group:		System/Libraries
Provides: libunshield = %EVR
Conflicts: libunshield < 1.4.3-alt1_3
Obsoletes: libunshield < 1.4.3-alt1_3


%description -n %{libname}
This package contains the shared libraries for %{name}.

%package -n %{devname}
Summary:	Development files and headers for %{name}
Group:		Development/Other
Requires:	%{libname} = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}
Provides:	lib%{name}-devel = %{version}-%{release}

%description -n %{devname}
This package contains the development files and headers for %{name}.

%prep
%setup -q
%patch100 -p1


%build
%{mageia_cmake}
%mageia_cmake_build

%install
%mageia_cmake_install

find %{buildroot} -name "*.la" -delete

%files
%doc README.md
%doc --no-dereference LICENSE
%{_bindir}/unshield
%{_mandir}/man1/unshield.1*

%files -n %{libname}
%{_libdir}/lib%{name}.so.%{major}
%{_libdir}/lib%{name}.so.%{major}.*

%files -n %{devname}
%{_libdir}/lib%{name}.so
%{_includedir}/lib%{name}.h
%{_libdir}/pkgconfig/lib%{name}.pc


%changelog
