%define _unpackaged_files_terminate_build 1

Name: update-kernel
Version: 1.19
Release: alt1
Summary: Update kernel and modules
License: GPL-2.0-or-later
Group: System/Kernel and hardware
Url: https://www.altlinux.org/update-kernel

Source: %name-%version.tar
BuildArch: noarch
%{?!_without_check:%{?!_disable_check:
BuildRequires: shellcheck
}}

Requires: apt
Requires: /usr/bin/rpmevrcmp
# May use rpm -q with an Epoch in the pkg argument (as well as Buildtime and
# Disttag -- but these are dependent on the output from APT, and APT cares
# about the correct dependencies on such features).
Requires: RPMQ(EPOCH)

%description
This package contains a script to conveniently update kernel and
modules.

It operates by installing a new package set in conjunction with your
existing kernel, ensuring that you do not lose the ability to boot your
reliable old kernel. By default, it searches for the most recent package
of the same flavor (e.g. "std-def") and aims to install all the same
modules that are already installed for that flavor.

This is recommended way of upgrading kernel for ALT Linux.

%prep
%setup

%install
mkdir -p %buildroot%_sbindir
install -pm755 update-kernel %buildroot%_sbindir/
install -pm755 remove-old-kernels %buildroot%_sbindir/
install -pm755 debuginfo-kernel-install -t %buildroot%_sbindir
install -Dp update-kernel.8 -t %buildroot%_man8dir/
install -Dp update-kernel.8.ru %buildroot%_mandir/ru/man8/update-kernel.8
install -Dp bash_completion %buildroot/usr/share/bash-completion/completions/update-kernel
ln -sf update-kernel %buildroot/usr/share/bash-completion/completions/remove-old-kernels
ln -sf update-kernel %buildroot/usr/share/bash-completion/completions/debuginfo-kernel-install

%check
make check

%files
%_sbindir/update-kernel
%_sbindir/remove-old-kernels
%_sbindir/debuginfo-kernel-install
%_man8dir/*.8*
%_mandir/ru/man8/*.8*
%_datadir/bash-completion/completions/*

%changelog
