%define _unpackaged_files_terminate_build 1
%def_disable embedded_cryptopp

Name: urbackup-client
Version: 2.5.25
Release: alt1
Summary: Efficient Client-Server backup system for Linux and Windows
Group: Archiving/Backup
License: AGPL-3.0+
Url: http://www.urbackup.org/
Source: %name-%version.tar.gz
Source2: %name-snapshot.cfg
Patch1: urbackup-client-fix-link-sqlite3.patch
Patch2: md5-bytes.patch
Patch3: uintptr_t.patch

BuildRequires: gcc-c++
BuildRequires: zlib-devel
BuildRequires: libzstd-devel
%{?_disable_embedded_cryptopp:BuildRequires: libcryptopp-devel}
BuildRequires: libsqlite3-devel
BuildRequires: libssl-devel
BuildRequires: libdevmapper-devel

Requires: urbackup-common

%description
Efficient Client-Server Backup system for Linux and Windows
with GPT and UEFI partition. A client for Windows lets you
backup open files and complete partition images. Backups
are stored to disks in a efficient way (deduplication)
on either Windows or Linux servers.

%prep
%setup -n %name-%version.0
%patch1 -p1
%patch2 -p0
%patch3 -p1

sed -i "s@/usr/local/sbin/urbackupclientbackend@%_sbindir/urbackupclientbackend@g" urbackupclientbackend-redhat.service
sed -i 's,armhf,armh,' cryptoplugin/src/configure.ac
sed -i 's,gnueabihf,gnueabi,' cryptoplugin/src/configure.ac
sed -i '/\#include \"cryptopp_inc.h\"/a #include "assert.h"' cryptoplugin/AESGCMDecryption.h

%build
export SUID_CFLAGS=-fPIE
export SUID_LDFLAGS=-fpie
%ifarch %ix86
%add_optflags -msse2
%endif
%ifarch %e2k
%add_optflags -mno-sse4.2 -mno-avx
%endif

%ifnarch x86_64
# Does not build with PIC by default on x86, see
# http://groups.google.com/group/cryptopp-users/browse_thread/thread/d639907b0b1816b9
%__subst '1 i #define CRYPTOPP_DISABLE_SSE2' cryptoplugin/src/config.h
%endif

%autoreconf
%configure \
    %{?_enable_embedded_cryptopp:--enable-embedded-cryptopp} \
    --without-embedded-sqlite3 \
    --enable-headless

%make_build

%install
%makeinstall_std
mkdir -p %buildroot{%_unitdir,%_man1dir,%_logdir,%_localstatedir/urbackup}
mkdir -p %buildroot%_sysconfdir/sysconfig
mkdir -p %buildroot%_initdir

install -m 644 defaults_client %buildroot%_sysconfdir/sysconfig/urbackupclient
install -m 644 urbackupclientbackend-redhat.service %buildroot%_unitdir/%name.service
install -m 644 docs/urbackupclientbackend.1 %buildroot%_man1dir/urbackupclientbackend.1

for f in linux_snapshot/*_snapshot; do
    [ -f "$f" ]
    install -m 755 "$f" "%buildroot%_datadir/urbackup/scripts/"
done

install -m 644 %SOURCE2 %buildroot%_sysconfdir/urbackup/snapshot.cfg
touch %buildroot%_logdir/urbackupclient.log

%post
%post_service %name

%preun
%preun_service %name

%files
%doc AUTHORS COPYING ChangeLog README
%config(noreplace) %_sysconfdir/sysconfig/urbackupclient
%dir %_sysconfdir/urbackup
%config(noreplace) %_sysconfdir/urbackup/*
%_bindir/urbackupclientctl
%_bindir/blockalign
%_sbindir/urbackupclientbackend
%_sbindir/urbackupclient_dmsnaptool
%_unitdir/%name.service
%_man1dir/*
%dir %attr(0755,urbackup,urbackup) %_datadir/urbackup
%attr(-,urbackup,urbackup) %_datadir/urbackup/*
%dir %attr(0755,urbackup,urbackup) %_localstatedir/urbackup
%attr(-,urbackup,urbackup) %_localstatedir/urbackup/*
%ghost %_logdir/urbackupclient.log

%changelog
